<?php
require_once __DIR__ . '/../api/check_session.php';

// --- 1. Verificación de Permisos ---
// Solo los administradores pueden acceder a esta página.
if (($_SESSION['user_puesto'] ?? '') !== 'Administrador') {
    http_response_code(403);
    die("<!DOCTYPE html><html><head><title>Acceso Denegado</title><link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css' rel='stylesheet'></head><body class='bg-light'><div class='container mt-5'><div class='alert alert-danger'><h4>Acceso Denegado</h4><p>No tienes permiso para ver este reporte.</p><a href='../index.php'>Volver al Dashboard</a></div></div></body></html>");
}

require_once __DIR__ . '/../config/db.php';
$pdo = get_db_connection();

// --- 2. Recopilación de Datos ---
$report_data = [];

try {
    // Obtener todos los profesionales
    $stmt = $pdo->query("SELECT id, nombre_completo, puesto, estado FROM professionals ORDER BY nombre_completo ASC");
    $professionals = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Inicializar datos del reporte para cada profesional
    foreach ($professionals as $prof) {
        $report_data[$prof['id']] = [
            'name' => $prof['nombre_completo'],
            'puesto' => $prof['puesto'],
            'estado' => $prof['estado'],
            'projects_assigned' => 0,
            'tasks_assigned' => 0,
            'tasks_completed' => 0,
            'chat_messages' => 0,
        ];
    }

    // Contar proyectos asignados por profesional
    $stmt = $pdo->query("SELECT professional_id, COUNT(project_id) as count FROM project_professionals GROUP BY professional_id");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (isset($report_data[$row['professional_id']])) {
            $report_data[$row['professional_id']]['projects_assigned'] = $row['count'];
        }
    }

    // Contar tareas asignadas y completadas por profesional
    $stmt = $pdo->query("
        SELECT 
            asignado_a, 
            COUNT(id) as total_tasks, 
            SUM(CASE WHEN porcentaje = 100 THEN 1 ELSE 0 END) as completed_tasks 
        FROM tasks 
        WHERE asignado_a IS NOT NULL 
        GROUP BY asignado_a
    ");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (isset($report_data[$row['asignado_a']])) {
            $report_data[$row['asignado_a']]['tasks_assigned'] = $row['total_tasks'];
            $report_data[$row['asignado_a']]['tasks_completed'] = $row['completed_tasks'];
        }
    }

    // Contar mensajes de chat por profesional
    $stmt = $pdo->query("SELECT sender_id, COUNT(id) as count FROM chat_messages GROUP BY sender_id");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (isset($report_data[$row['sender_id']])) {
            $report_data[$row['sender_id']]['chat_messages'] = $row['count'];
        }
    }

} catch (PDOException $e) {
    // Manejo de errores de base de datos
    die("Error al generar el reporte: " . $e->getMessage());
}

?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Actividad de Usuario - Platflow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        @media print {
            .no-print {
                display: none;
            }
            body {
                background-color: #fff;
            }
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3 no-print">
        <a href="../index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Volver al Dashboard</a>
        <button class="btn btn-primary" onclick="window.print()"><i class="bi bi-printer-fill"></i> Imprimir Reporte</button>
    </div>

    <div class="card">
        <div class="card-header text-center">
            <h2>Reporte de Actividad de Usuario</h2>
            <p class="lead mb-0">Generado el: <?php echo date('d/m/Y H:i:s'); ?></p>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>Profesional</th>
                            <th>Puesto</th>
                            <th>Estado</th>
                            <th class="text-center">Proyectos Asignados</th>
                            <th class="text-center">Tareas Asignadas</th>
                            <th class="text-center">Tareas Completadas</th>
                            <th class="text-center">Mensajes de Chat</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($report_data)): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">No hay profesionales para mostrar.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($report_data as $data): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($data['name']); ?></td>
                                    <td><?php echo htmlspecialchars($data['puesto']); ?></td>
                                    <td>
                                        <span class="badge <?php echo $data['estado'] === 'Activo' ? 'bg-success' : 'bg-secondary'; ?>">
                                            <?php echo htmlspecialchars($data['estado']); ?>
                                        </span>
                                    </td>
                                    <td class="text-center"><?php echo (int)$data['projects_assigned']; ?></td>
                                    <td class="text-center"><?php echo (int)$data['tasks_assigned']; ?></td>
                                    <td class="text-center"><?php echo (int)$data['tasks_completed']; ?></td>
                                    <td class="text-center"><?php echo (int)$data['chat_messages']; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer text-muted text-center">
            Fin del reporte.
        </div>
    </div>
</div>

</body>
</html>