<?php
$is_installed = file_exists(__DIR__ . '/config/db.php');
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Platflow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body, html { height: 100%; margin: 0; font-family: Arial, sans-serif; background-color: #f4f7f6; }
        .login-container { display: flex; justify-content: center; align-items: center; height: 100%; }
        .login-box { padding: 40px; background-color: #ffffff; box-shadow: 0 4px 20px rgba(0,0,0,0.1); border-radius: 8px; text-align: center; width: 100%; max-width: 450px; }
        .login-box h1 { margin-bottom: 24px; color: #333; }
        .login-box .input-group { margin-bottom: 20px; text-align: left; }
        .login-box label { display: block; margin-bottom: 8px; color: #666; }
        .login-box input { width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
        .login-box button, .login-box .btn { width: 100%; padding: 12px; font-size: 16px; }
        #error-message { color: red; margin-top: 15px; min-height: 20px; }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <h1>Bienvenido a Platflow</h1>

            <?php if ($is_installed): ?>
                <!-- Formulario de Login si está instalado -->
                <form id="login-form">
                    <div class="input-group">
                        <label for="email">Correo Electrónico</label>
                        <input type="email" id="email" name="email" required>
                    </div>
                    <div class="input-group">
                        <label for="password">Contraseña</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Iniciar Sesión</button>
                    <div id="error-message"></div>
                </form>
                <script src="js/login.js"></script>
            <?php else: ?>
                <!-- Mensaje de error si no está instalado -->
                <div class="alert alert-danger">
                    <h4 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> ¡Aplicación no instalada!</h4>
                    <p>Platflow no parece estar configurado. El archivo <code>config/db.php</code> no se encuentra.</p>
                    <hr>
                    <p class="mb-0">Por favor, ejecute el asistente de instalación para configurar la base de datos y crear el usuario administrador.</p>
                </div>
                <a href="install.php" class="btn btn-success">
                    <i class="bi bi-gear-fill"></i> Ir al Instalador
                </a>
            <?php endif; ?>

        </div>
    </div>

    <?php if ($is_installed): ?>
    <script>
        // El script de login.js se mueve aquí para que solo se ejecute si la app está instalada.
        document.getElementById('login-form').addEventListener('submit', async function(e) {
            e.preventDefault();
            const form = e.target;
            const errorMessageDiv = document.getElementById('error-message');
            const button = form.querySelector('button');

            button.disabled = true;
            button.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verificando...';
            errorMessageDiv.textContent = '';

            const formData = new FormData(form);

            try {
                const response = await fetch('api/login.php', { method: 'POST', body: formData });
                const result = await response.json();

                if (result.success) {
                    window.location.href = 'index.php';
                } else {
                    errorMessageDiv.textContent = result.message || 'Error desconocido.';
                }
            } catch (error) {
                errorMessageDiv.textContent = 'Error de red. No se pudo conectar con el servidor.';
            } finally {
                button.disabled = false;
                button.textContent = 'Iniciar Sesión';
            }
        });
    </script>
    <?php endif; ?>
</body>
</html>