document.addEventListener('DOMContentLoaded', function() {
    const pagesContainer = document.getElementById('pages-list-container');
    const form = document.getElementById('page-selection-form');
    const confirmBtn = document.getElementById('confirm-selection-btn');

    // Esta función obtiene las páginas desde un nuevo endpoint que las lee de la sesión.
    async function loadPages() {
        try {
            // Hacemos una llamada a un endpoint que simplemente devuelve los datos de la sesión.
            const response = await fetch('api/meta_save_page.php?action=get_pages');
            if (!response.ok) {
                throw new Error('No se pudo obtener la lista de páginas.');
            }
            const pages = await response.json();

            if (!pages || pages.length === 0) {
                pagesContainer.innerHTML = '<p class="text-danger text-center">No se encontraron páginas en la sesión. Por favor, intente el proceso de conexión de nuevo.</p>';
                return;
            }

            pagesContainer.innerHTML = pages.map(page => `
                <label class="list-group-item list-group-item-action">
                    <input class="form-check-input me-2" type="radio" name="selected_page" value="${page.id}" required>
                    ${page.name}
                </label>
            `).join('');

            // Habilitar el botón cuando se selecciona una página
            pagesContainer.addEventListener('change', () => {
                confirmBtn.disabled = false;
            });

        } catch (error) {
            console.error('Error:', error);
            pagesContainer.innerHTML = `<div class="alert alert-danger">${error.message}</div>`;
        }
    }

    // Esta función envía la página seleccionada al backend para guardarla.
    async function saveSelectedPage(event) {
        event.preventDefault();
        const selectedPageId = form.querySelector('input[name="selected_page"]:checked').value;

        confirmBtn.disabled = true;
        confirmBtn.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Conectando...';

        // Hacemos un POST al mismo endpoint para guardar la selección.
        const response = await fetch('api/meta_save_page.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ page_id: selectedPageId })
        });

        window.location.href = 'configuracion.html'; // Redirigir a configuración
    }

    form.addEventListener('submit', saveSelectedPage);
    loadPages();
});