document.addEventListener('DOMContentLoaded', () => {
    const darkModeToggle = document.getElementById('dark-mode-toggle');
    const body = document.body;
    const sidebarContainer = document.getElementById('sidebar');

    const darkModeStateKey = 'darkModeEnabled';

    // --- Lógica del Modo Oscuro ---
    // Aplicar estado guardado del modo oscuro al cargar
    const isDarkModeEnabled = localStorage.getItem(darkModeStateKey) === 'true';
    if (isDarkModeEnabled) {
        body.classList.add('dark-mode');
        if (darkModeToggle) darkModeToggle.checked = true;
    }

    // Manejar clic en el interruptor de modo oscuro
    if (darkModeToggle) {
        darkModeToggle.addEventListener('change', () => {
            if (darkModeToggle.checked) {
                body.classList.add('dark-mode');
                localStorage.setItem(darkModeStateKey, 'true');
            } else {
                body.classList.remove('dark-mode');
                localStorage.setItem(darkModeStateKey, 'false');
            }
        });
    }

    // --- Lógica del Submenú de Agendas ---
    const agendasSubmenu = document.getElementById('agendasSubmenu');
    if (agendasSubmenu) {
        const agendaLink = document.querySelector('a[href="#agendasSubmenu"]');

        // Guardar el estado del submenú
        agendasSubmenu.addEventListener('show.bs.collapse', function () {
            localStorage.setItem('agendasSubmenuOpen', 'true');
        });

        agendasSubmenu.addEventListener('hide.bs.collapse', function () {
            localStorage.setItem('agendasSubmenuOpen', 'false');
        });

        // Restaurar el estado del submenú al cargar la página
        if (localStorage.getItem('agendasSubmenuOpen') === 'true') {
            agendasSubmenu.classList.add('show');
            agendaLink.setAttribute('aria-expanded', 'true');
        } else {
            agendaLink.classList.add('collapsed');
            agendaLink.setAttribute('aria-expanded', 'false');
        }
    }

});