document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('projects-calendar');
    const PROJECTS_API_URL = 'api/projects.php';
 
    async function initialLoad() {
        try {
            const projectsRes = await fetch(PROJECTS_API_URL);
            if (!projectsRes.ok) throw new Error('No se pudieron cargar los proyectos.');
            
            const projects = await projectsRes.json();
            renderCalendar(projects);
 
        } catch (error) {
            console.error("Error en la carga de la agenda de proyectos:", error);
            calendarEl.innerHTML = `<div class="alert alert-danger">Error al cargar el calendario: ${error.message}</div>`;
        }
    }
 
    function renderCalendar(projects) {
        const projectEvents = projects.map(project => {
            // Evento para la Fecha de Fin Estimada (si no está completado)
            if (project.fecha_fin_estimada && project.estado !== 'Completado') {
                return {
                    id: `est-${project.id}`,
                    title: `Fin Estimado: ${project.nombre_proyecto}`,
                    start: project.fecha_fin_estimada,
                    allDay: true,
                    backgroundColor: '#fd7e14', // Naranja
                    borderColor: '#fd7e14',
                    url: `project-detail.html?id=${project.id}`
                };
            }
 
            // Evento para la Fecha de Fin Real (si está completado)
            if (project.estado === 'Completado' && project.fecha_fin_real) {
                return {
                    id: `real-${project.id}`,
                    title: `Completado: ${project.nombre_proyecto}`,
                    start: project.fecha_fin_real,
                    allDay: true,
                    backgroundColor: '#198754', // Verde
                    borderColor: '#146c43',
                    url: `project-detail.html?id=${project.id}`
                };
            }
            return null; // Si un proyecto no tiene fecha, no genera evento
        }).filter(Boolean); // Limpiar los elementos nulos del array
 
        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'es',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,listWeek'
            },
            events: projectEvents
        });
        calendar.render();
    }
 
    initialLoad();
});