<?php
// Prevenir la ejecución si ya está instalado
if (file_exists(__DIR__ . '/config/db.php')) {
    header('Location: login.php');
    exit;
}
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalación de Platflow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { background-color: #f4f7f6; }
        .installer-container { max-width: 600px; margin: 5rem auto; }
    </style>
</head>
<body>
<div class="container">
    <div class="installer-container">
        <div class="card shadow-sm">
            <div class="card-header text-center bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-rocket-takeoff-fill"></i> Instalación de Platflow</h4>
            </div>
            <div class="card-body p-4">
                <p>¡Bienvenido! Estás a punto de instalar Platflow. Por favor, proporciona los detalles de tu base de datos MySQL. <strong>Debes crear una base de datos vacía primero</strong> en tu servidor MySQL.</p>
                
                <div id="error-message" class="alert alert-danger" style="display: none;"></div>

                <form id="install-form">
                    <h5 class="mt-4">1. Conexión a la Base de Datos</h5>
                    <div class="mb-3">
                        <label for="db_host" class="form-label">Host de la Base de Datos</label>
                        <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                    </div>
                    <div class="mb-3">
                        <label for="db_name" class="form-label">Nombre de la Base de Datos</label>
                        <input type="text" class="form-control" id="db_name" name="db_name" placeholder="platflow_db" required>
                    </div>
                    <div class="mb-3">
                        <label for="db_user" class="form-label">Usuario de la Base de Datos</label>
                        <input type="text" class="form-control" id="db_user" name="db_user" value="root" required>
                    </div>
                    <div class="mb-3">
                        <label for="db_pass" class="form-label">Contraseña del Usuario</label>
                        <input type="password" class="form-control" id="db_pass" name="db_pass">
                    </div>
                    <hr>
                    <h5 class="mt-4">2. Crear Usuario Administrador</h5>
                    <p class="text-muted small">Este será el primer usuario para acceder a Platflow.</p>
                     <div class="mb-3">
                        <label for="admin_name" class="form-label">Nombre Completo del Administrador</label>
                        <input type="text" class="form-control" id="admin_name" name="admin_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="admin_puesto" class="form-label">Puesto del Administrador</label>
                        <select class="form-select" id="admin_puesto" name="admin_puesto" required>
                            <option value="Administrador">Administrador (Recomendado)</option>
                            <option value="Director de Cuentas">Director de Cuentas</option>
                            <option value="Director Creativo">Director Creativo</option>
                        </select>
                    </div>
                     <div class="mb-3">
                        <label for="admin_email" class="form-label">Email del Administrador</label>
                        <input type="email" class="form-control" id="admin_email" name="admin_email" required>
                    </div>
                     <div class="mb-3">
                        <label for="admin_password" class="form-label">Contraseña del Administrador</label>
                        <input type="password" class="form-control" id="admin_password" name="admin_password" required>
                    </div>

                    <div class="d-grid">
                        <button type="submit" id="submit-btn" class="btn btn-primary btn-lg">
                            <i class="bi bi-check-circle-fill"></i> Instalar Ahora
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <footer class="text-center mt-3 text-muted">
            <small>Platflow v1.0</small>
        </footer>
    </div>
</div>

<script>
document.getElementById('install-form').addEventListener('submit', async function(e) {
    e.preventDefault();
    const form = e.target;
    const button = document.getElementById('submit-btn');
    const errorDiv = document.getElementById('error-message');
    
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Verificando y creando tablas...';
    errorDiv.style.display = 'none';

    const formData = new FormData(form);
    const response = await fetch('api/setup.php', { method: 'POST', body: formData });
    const result = await response.json();

    if (result.success) {
        alert('¡Instalación completada con éxito! Serás redirigido a la página de inicio de sesión. Por seguridad, elimina el archivo install.php de tu servidor.');
        window.location.href = 'login.php';
    } else {
        errorDiv.textContent = 'Error: ' + result.message;
        errorDiv.style.display = 'block';
        button.disabled = false;
        button.innerHTML = '<i class="bi bi-check-circle-fill"></i> Instalar Ahora';
    }
});
</script>
</body>
</html>