<?php

/**
 * Define claves de seguridad.
 * ¡IMPORTANTE! En un entorno de producción, estas claves NUNCA deben estar
 * directamente en el código. Deben cargarse desde variables de entorno
 * o un archivo de configuración seguro fuera del control de versiones.
 * 
 * Para generar claves seguras, puedes usar:
 * echo 'ENCRYPTION_KEY=' . bin2hex(random_bytes(32)) . "\n";
 * echo 'ENCRYPTION_IV=' . bin2hex(random_bytes(16)) . "\n";
 */
define('ENCRYPTION_KEY', 'e8a6d2de7b8f9c1a3b4c5d6e7f8g9h0i1j2k3l4m5n6o7p8q9r0s1t2u3v4w5x6y'); // Clave de 32 bytes (64 hex)
define('ENCRYPTION_IV', 'a1b2c3d4e5f6g7h8i9j0k1l2m3n4o5p6'); // IV de 16 bytes (32 hex)
define('ENCRYPTION_METHOD', 'aes-256-cbc');

/**
 * Encripta un token o clave API.
 *
 * @param string $string El texto plano a encriptar.
 * @return string|false El texto cifrado en base64 o false si falla.
 */
function encrypt_token($string) {
    $key = hex2bin(ENCRYPTION_KEY);
    $iv = hex2bin(ENCRYPTION_IV);
    $encrypted = openssl_encrypt($string, ENCRYPTION_METHOD, $key, 0, $iv);
    return base64_encode($encrypted);
}

/**
 * Desencripta un token o clave API.
 *
 * @param string $encrypted_string El texto cifrado en base64.
 * @return string|false El texto plano original o false si falla.
 */
function decrypt_token($encrypted_string) {
    $key = hex2bin(ENCRYPTION_KEY);
    $iv = hex2bin(ENCRYPTION_IV);
    $decrypted = openssl_decrypt(base64_decode($encrypted_string), ENCRYPTION_METHOD, $key, 0, $iv);
    return $decrypted;
}

?>