<?php
/**
 * Configuración global de la aplicación.
 */

// --- Detección automática de la URL base ---

// Determina si la conexión es HTTPS
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

// Obtiene el host (dominio)
$host = $_SERVER['HTTP_HOST'];

// Obtiene la ruta base del script, eliminando /config y /install si están presentes
$script_path = str_replace(['/config', '/install'], '', dirname($_SERVER['SCRIPT_NAME']));
$base_path = rtrim($script_path, '/'); // Elimina la barra final si existe

define('BASE_URL', $protocol . $host . $base_path);
?>