<?php

// --- 1. Verificación de Seguridad ---
// Este script solo debe ejecutarse desde la línea de comandos (CLI), no desde un navegador.
if (php_sapi_name() !== 'cli') {
    http_response_code(403);
    die("Acceso denegado. Este script es solo para ejecución desde la línea de comandos (CLI).");
}

echo "--- Iniciando script de mantenimiento de Platflow ---\n";
date_default_timezone_set('America/Asuncion'); // Ajusta a tu zona horaria

// --- 2. Incluir configuración de la base de datos ---
require_once __DIR__ . '/../config/db.php';
$pdo = get_db_connection();


// --- 3. Limpieza de Backups Antiguos ---

echo "\n[TAREA 1/2] Limpiando backups antiguos...\n";
$backup_dir = __DIR__ . '/../backups/';
$max_backup_age_days = 30; // Días que se conservarán los backups
$deleted_backups_count = 0;

if (is_dir($backup_dir)) {
    $backup_files = glob($backup_dir . '*.sql.gz');
    foreach ($backup_files as $file) {
        if (is_file($file) && (time() - filemtime($file) > ($max_backup_age_days * 86400))) {
            if (unlink($file)) {
                echo "  - Eliminado backup antiguo: " . basename($file) . "\n";
                $deleted_backups_count++;
            } else {
                echo "  - ERROR: No se pudo eliminar " . basename($file) . "\n";
            }
        }
    }
    echo "  -> Tarea completada. Se eliminaron $deleted_backups_count backups.\n";
} else {
    echo "  -> Directorio de backups no encontrado. Omitiendo.\n";
}


// --- 4. Limpieza de Archivos Huérfanos en /uploads ---

echo "\n[TAREA 2/2] Buscando archivos huérfanos en /uploads...\n";
$uploads_dir = __DIR__ . '/../uploads/';
$deleted_orphans_count = 0;

// Paso A: Obtener una lista de todos los archivos en el disco
$disk_files = [];
if (is_dir($uploads_dir)) {
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($uploads_dir, FilesystemIterator::SKIP_DOTS));
    foreach ($iterator as $file) {
        if ($file->isFile()) {
            // Guardar la ruta relativa, que es como se almacena en la BD
            $relative_path = str_replace(__DIR__ . '/../', '', $file->getPathname());
            $disk_files[] = str_replace('\\', '/', $relative_path); // Normalizar separadores para Windows
        }
    }
    echo "  - Se encontraron " . count($disk_files) . " archivos en el directorio de subidas.\n";
} else {
    echo "  -> Directorio de uploads no encontrado. Omitiendo.\n";
    $disk_files = [];
}

// Paso B: Obtener una lista de todos los archivos referenciados en la base de datos
$db_files = [];

// Profesionales (foto_url)
$stmt = $pdo->query("SELECT foto_url FROM professionals WHERE foto_url IS NOT NULL AND foto_url != ''");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $db_files[] = $row['foto_url'];
}

// Tareas (archivos)
$stmt = $pdo->query("SELECT archivos FROM tasks WHERE JSON_LENGTH(archivos) > 0");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $files_in_task = json_decode($row['archivos'], true);
    foreach ($files_in_task as $file_info) {
        if (isset($file_info['path'])) {
            $db_files[] = $file_info['path'];
        }
    }
}

// Conversaciones de Chat (group_photo_url)
$stmt = $pdo->query("SELECT group_photo_url FROM chat_conversations WHERE group_photo_url IS NOT NULL AND group_photo_url != ''");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $db_files[] = $row['group_photo_url'];
}

// Configuración (logo de la agencia)
$stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'agency_data'");
$agency_data_json = $stmt->fetchColumn();
if ($agency_data_json) {
    $agency_data = json_decode($agency_data_json, true);
    if (!empty($agency_data['logo_url'])) {
        $db_files[] = $agency_data['logo_url'];
    }
}

// Eliminar duplicados y valores vacíos
$db_files = array_unique(array_filter($db_files));
echo "  - Se encontraron " . count($db_files) . " referencias a archivos en la base de datos.\n";

// Paso C: Comparar y eliminar los huérfanos
$orphan_files = array_diff($disk_files, $db_files);

if (empty($orphan_files)) {
    echo "  -> No se encontraron archivos huérfanos.\n";
} else {
    foreach ($orphan_files as $orphan) {
        $full_path = __DIR__ . '/../' . $orphan;
        if (is_file($full_path)) {
            if (unlink($full_path)) {
                echo "  - Eliminado archivo huérfano: " . $orphan . "\n";
                $deleted_orphans_count++;
            } else {
                echo "  - ERROR: No se pudo eliminar el archivo huérfano: " . $orphan . "\n";
            }
        }
    }
}
echo "  -> Tarea completada. Se eliminaron $deleted_orphans_count archivos huérfanos.\n";

echo "\n--- Script de mantenimiento finalizado. ---\n";
?>