<?php
    include 'api/check_session.php';
    $puesto = $_SESSION['user_puesto'] ?? '';
    $no_finance_roles = ['CM', 'Copy', 'Diseñadores', 'Audiovisual', 'Periodismo', 'BTL', 'ATL'];
    $no_professionals_roles = ['Copy', 'Diseñadores', 'Audiovisual', 'Periodismo', 'BTL', 'ATL'];
    $can_see_finance = !in_array($puesto, $no_finance_roles);
    $can_see_professionals = !in_array($puesto, $no_professionals_roles);
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat - Platflow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        /* Estilos para los tabs del nuevo modal */
        #professionals-list {
            max-height: 300px;
            overflow-y: auto;
        }

        /* Ocultar contenido de tabs no activos */
        .tab-content:not(.active) {
            display: none;
        }

        /* Ajustes para el modal de Bootstrap */
        #new-chat-modal .modal-body {
            padding-top: 0;
        }

        #new-chat-modal .nav-tabs {
            margin-bottom: 1rem;
        }

        /* Estilos para los miembros seleccionados en el grupo */
        .selected-member-pill {
            display: inline-flex;
            align-items: center;
            background-color: #e0e0e0;
            border-radius: 16px;
            padding: 4px 8px;
            margin-right: 5px;
            margin-bottom: 5px;
            font-size: 0.9em;
        }
        .remove-member-btn {
            margin-left: 8px;
            cursor: pointer;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse h-100">
            <div class="position-sticky pt-3">
                <h4 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <a href="/platflow/" class="text-decoration-none text-muted"><span>Platflow</span></a>
                </h4>
                <ul class="nav flex-column mb-auto">
                    <li class="nav-item"><a class="nav-link" href="/platflow/"><i class="bi bi-house-door-fill me-2"></i>Dashboard</a></li>
                    <?php if ($can_see_professionals): ?>
                    <li class="nav-item"><a class="nav-link" href="professionals.html"><i class="bi bi-people-fill me-2"></i>Profesionales</a></li>
                    <?php endif; ?>
                    <li class="nav-item"><a class="nav-link" href="clients.html"><i class="bi bi-person-rolodex me-2"></i>Clientes</a></li>
                    <li class="nav-item"><a class="nav-link" href="projects.html"><i class="bi bi-kanban-fill me-2"></i>Proyectos</a></li>
                    <li class="nav-item"><a class="nav-link active" aria-current="page" href="chat.php"><i class="bi bi-chat-dots-fill me-2"></i>Chat</a></li>
                    <li class="nav-item"><a class="nav-link" href="content-grid.html"><i class="bi bi-grid-3x3-gap-fill me-2"></i>Editorial de Redes</a></li>
                    <li class="nav-item"><a class="nav-link" href="media-plan.html"><i class="bi bi-calendar-check-fill me-2"></i>Plan de Medios</a></li>
                    <li class="nav-item"><a class="nav-link" href="analizar-datos.html"><i class="bi bi-bar-chart-line-fill me-2"></i>Analizar Datos</a></li>
                    <?php if ($can_see_finance): ?>
                    <li class="nav-item"><a class="nav-link" href="finance.html"><i class="bi bi-currency-dollar me-2"></i>Finanzas</a></li>
                    <?php endif; ?>
                    <li class="nav-item"><a class="nav-link" href="all-tasks.html"><i class="bi bi-check2-circle me-2"></i>Todas las Tareas</a></li>
                </ul>
                <hr>
                <div class="px-3 mt-auto pb-3">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" role="switch" id="dark-mode-toggle">
                        <label class="form-check-label" for="dark-mode-toggle">Modo Oscuro</label>
                    </div>
                    <ul class="nav flex-column">
                        <li class="nav-item"><a class="nav-link" href="configuracion.html"><i class="bi bi-gear-fill me-2"></i>Configuración</a></li>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
             <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Chat</h1>
                <div class="d-flex align-items-center ms-auto">
                    <div id="global-search-container" class="me-2" style="position: relative;">
                        <input class="form-control form-control-sm" type="search" id="global-search-input" placeholder="Buscar proyecto, cliente, tarea..." aria-label="Search" style="width: 300px;">
                        <ul id="global-search-results" class="dropdown-menu"></ul>
                    </div>
                    <button id="global-chat-button" class="btn btn-outline-primary" type="button" title="Abrir Chat">
                        <i class="bi bi-chat-dots-fill position-relative">
                            <span id="chat-notification-badge" class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle" style="display: none;"></span>
                        </i>
                    </button>
                </div>
            </div>
            <div class="alert alert-info">
                <h4 class="alert-heading">¡El chat ahora es global!</h4>
                <p>Puedes acceder al chat desde cualquier página usando el nuevo botón azul que aparece en la esquina inferior derecha de la pantalla.</p>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="js/main.js"></script>

</body>
</html>