<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../config/security.php';

$uploads_dir = '../uploads/agency/';

if (!is_dir($uploads_dir)) {
    mkdir($uploads_dir, 0777, true);
}

/**
 * Obtiene todas las configuraciones de la base de datos.
 * @param PDO $pdo
 * @return array
 */
function get_all_settings($pdo) {
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
    $settings_flat = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
    $settings = [];
    foreach ($settings_flat as $key => $value) {
        $settings[$key] = json_decode($value, true);
    }
    return $settings;
}

/**
 * Guarda un valor de configuración en la base de datos.
 * @param PDO $pdo
 * @param string $key
 * @param array $value
 */
function save_setting($pdo, $key, $value) {
    $json_value = json_encode($value);
    $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (:key, :value) ON DUPLICATE KEY UPDATE setting_value = :value");
    $stmt->execute(['key' => $key, 'value' => $json_value]);
}

$method = $_SERVER['REQUEST_METHOD'];
$pdo = get_db_connection();

if ($method === 'GET') {
    $settings = get_all_settings($pdo);
    echo json_encode($settings);

} elseif ($method === 'POST') {
    $settings = get_all_settings($pdo);

    // Determinar qué formulario se está guardando
    $form_type = $_POST['form_type'] ?? '';

    if ($form_type === 'agency_data') {
        // --- GUARDAR DATOS DE LA AGENCIA ---
        $agency_data = $_POST;
        $current_agency_data = $settings['agency_data'] ?? [];
        $logo_path = $current_agency_data['logo_url'] ?? null;

        // Manejo de la subida del logo
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $tmp_name = $_FILES['logo']['tmp_name'];
            $file_name = 'logo_' . time() . '_' . basename($_FILES['logo']['name']);
            $destination = $uploads_dir . $file_name;
            if ($logo_path && file_exists('..' . $logo_path)) {
                unlink('..' . $logo_path);
            }
            if (move_uploaded_file($tmp_name, $destination)) {
                $logo_path = str_replace('..', '', $destination);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo mover el archivo subido.']);
                exit;
            }
        }
        
        $current_agency_data['agency_name'] = $agency_data['agency_name'] ?? $current_agency_data['agency_name'] ?? '';
        $current_agency_data['business_name'] = $agency_data['business_name'] ?? $current_agency_data['business_name'] ?? '';
        $current_agency_data['ruc'] = $agency_data['ruc'] ?? $current_agency_data['ruc'] ?? '';
        $current_agency_data['legal_rep'] = $agency_data['legal_rep'] ?? $current_agency_data['legal_rep'] ?? '';
        $current_agency_data['commercial_email'] = $agency_data['commercial_email'] ?? $current_agency_data['commercial_email'] ?? '';
        $current_agency_data['commercial_phone'] = $agency_data['commercial_phone'] ?? $current_agency_data['commercial_phone'] ?? '';
        $current_agency_data['finance_email'] = $agency_data['finance_email'] ?? $current_agency_data['finance_email'] ?? '';
        $current_agency_data['finance_phone'] = $agency_data['finance_phone'] ?? $current_agency_data['finance_phone'] ?? '';
        $current_agency_data['website'] = $agency_data['website'] ?? $current_agency_data['website'] ?? '';
        $current_agency_data['address'] = $agency_data['address'] ?? $current_agency_data['address'] ?? '';
        $current_agency_data['city'] = $agency_data['city'] ?? $current_agency_data['city'] ?? '';
        $current_agency_data['country'] = $agency_data['country'] ?? $current_agency_data['country'] ?? '';
        $current_agency_data['logo_url'] = $logo_path;

        save_setting($pdo, 'agency_data', $current_agency_data);
        $settings['agency_data'] = $current_agency_data;

    } elseif ($form_type === 'system_settings') {
        // --- GUARDAR AJUSTES DEL SISTEMA ---
        $system_data = $_POST;
        $current_system_settings = $settings['system_settings'] ?? [];
        $new_system_settings = [
            'thousands_separator' => $system_data['thousands_separator'] ?? '.',
            'decimal_separator' => $system_data['decimal_separator'] ?? ',',
            'decimal_places' => isset($system_data['decimal_places']) ? (int)$system_data['decimal_places'] : 0,
            'percentage_decimals' => isset($system_data['percentage_decimals']) ? (int)$system_data['percentage_decimals'] : 1,
            'currency_code' => $system_data['currency_code'] ?? 'PYG',
            'currency_symbol' => $system_data['currency_symbol'] ?? 'Gs.',
        ];
        $settings['system_settings'] = array_merge($current_system_settings, $new_system_settings);
        save_setting($pdo, 'system_settings', $settings['system_settings']);

    } elseif ($form_type === 'ai_settings') {
        // --- GUARDAR AJUSTES DE IA ---
        $ai_data = $_POST;
        $current_ai_settings = $settings['ai_settings'] ?? [];

        $new_api_key = $ai_data['api_key'] ?? null;
        if (!empty($new_api_key)) {
            $current_ai_settings['api_key'] = encrypt_token($new_api_key);
        }

        $current_ai_settings['ai_provider'] = $ai_data['ai_provider'] ?? 'gemini';
        $current_ai_settings['ai_model'] = $ai_data['ai_model'] ?? '';

        save_setting($pdo, 'ai_settings', $current_ai_settings);
        $settings['ai_settings'] = $current_ai_settings;

    } elseif ($form_type === 'meta_settings') {
        // --- GUARDAR AJUSTES DE META ---
        $meta_data = $_POST;
        $current_meta_settings = $settings['meta_settings'] ?? [];

        $new_app_secret = $meta_data['meta_app_secret'] ?? null;
        if (!empty($new_app_secret)) {
            $current_meta_settings['meta_app_secret'] = encrypt_token($new_app_secret);
        }
        $current_meta_settings['meta_app_id'] = $meta_data['meta_app_id'] ?? '';

        save_setting($pdo, 'meta_settings', $current_meta_settings);
        $settings['meta_settings'] = $current_meta_settings;

    } elseif ($form_type === 'disconnect_meta') {
        // --- DESCONECTAR CUENTA DE META ---
        $current_meta_settings = $settings['meta_settings'] ?? [];
        unset($current_meta_settings['page_id']);
        unset($current_meta_settings['page_access_token']);
        save_setting($pdo, 'meta_settings', $current_meta_settings);
        $settings['meta_settings'] = $current_meta_settings;

    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Tipo de formulario no reconocido.']);
        exit;
    }

    http_response_code(200);
    echo json_encode([
        'message' => 'Configuración guardada con éxito.',
        'data' => $settings
    ]);

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>