<?php
session_start();
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/security.php';

function get_meta_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'meta_settings'");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    if ($result) {
        return json_decode($result, true);
    }
    return [];
}

$method = $_SERVER['REQUEST_METHOD'];
$pdo = get_db_connection();

if ($method === 'GET' && isset($_GET['action']) && $_GET['action'] === 'get_pages') {
    // --- Acción para obtener las páginas de la sesión ---
    $pages = $_SESSION['meta_pages'] ?? [];
    
    // Solo devolvemos el nombre y el ID, no el token de página al frontend.
    $safe_pages = array_map(function($page) {
        return ['id' => $page['id'], 'name' => $page['name']];
    }, $pages);

    echo json_encode($safe_pages);
    exit;
}

if ($method === 'POST') {
    // --- Acción para guardar la página seleccionada ---
    $input = json_decode(file_get_contents('php://input'), true);
    $selected_page_id = $input['page_id'] ?? null;

    if (!$selected_page_id) {
        http_response_code(400);
        echo json_encode(['error' => 'No se seleccionó ninguna página.']);
        exit;
    }

    $pages_in_session = $_SESSION['meta_pages'] ?? [];
    $selected_page_data = null;

    foreach ($pages_in_session as $page) {
        if ($page['id'] == $selected_page_id) {
            $selected_page_data = $page;
            break;
        }
    }

    if (!$selected_page_data) {
        http_response_code(404);
        echo json_encode(['error' => 'La página seleccionada no se encontró en la sesión.']);
        exit;
    }

    // Guardar el ID de la página y su token de acceso en la configuración
    $meta_settings = get_meta_settings($pdo);
    $meta_settings['page_id'] = $selected_page_data['id'];
    $meta_settings['page_access_token'] = encrypt_token($selected_page_data['access_token']);

    $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('meta_settings', :value) ON DUPLICATE KEY UPDATE setting_value = :value");
    $stmt->execute(['value' => json_encode($meta_settings)]);

    // Limpiar la sesión
    unset($_SESSION['meta_pages']);

    echo json_encode(['message' => 'Página conectada con éxito.']);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Método no permitido o acción no especificada.']);
?>