<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../config/security.php';

/**
 * Lee la configuración de Meta desde la base de datos.
 * @return array
 */
function get_meta_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'meta_settings'");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    if ($result) {
        return json_decode($result, true);
    }
    return null;
}

$method = $_SERVER['REQUEST_METHOD'];
$pdo = get_db_connection();

if ($method !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
    exit;
}

// --- 1. Obtener configuración y datos del post ---
$meta_settings = get_meta_settings($pdo);
$page_id = $meta_settings['page_id'] ?? null;
$encrypted_token = $meta_settings['page_access_token'] ?? null;
$page_access_token = $encrypted_token ? decrypt_token($encrypted_token) : null;

if (!$page_id || !$page_access_token) {
    http_response_code(409); // Conflict
    echo json_encode(['error' => 'No hay una página de Meta conectada. Por favor, ve a Configuración -> Conexiones.']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$post_data = [
    'message' => $input['copy'] ?? '',
    'published' => false, // Para que sea un post programado
    'scheduled_publish_time' => $input['scheduled_publish_time'] ?? null,
    'access_token' => $page_access_token
];

// --- 2. Realizar la llamada a la API de Meta ---
$url = "https://graph.facebook.com/v20.0/{$page_id}/feed";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$result = json_decode($response, true);

if ($http_code >= 400) {
    http_response_code($http_code);
    echo json_encode(['error' => $result['error']['message'] ?? 'Error desconocido al publicar en Meta.']);
} else {
    echo json_encode(['message' => '¡Post programado en Meta con éxito! ID del post: ' . ($result['id'] ?? 'N/A')]);
}
?>