<?php
session_start();
require_once __DIR__ . '/../config/db.php';
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../config/config.php'; // Incluir la configuración global
require_once __DIR__ . '/../config/security.php';

/**
 * Lee la configuración de Meta desde la base de datos.
 * @return array
 */
function get_meta_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'meta_settings'");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    if ($result) {
        return json_decode($result, true);
    }
    return null;
}

/**
 * Muestra una página de error amigable.
 * @param string $title El título del error.
 * @param string $message El mensaje detallado del error.
 */
function die_with_error_page($title, $message) {
    echo "<!DOCTYPE html><html lang='es'><head><meta charset='UTF-8'><title>Error de Conexión</title>";
    echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
    echo "</head><body class='bg-light'><div class='container mt-5'><div class='alert alert-danger'>";
    echo "<h4 class='alert-heading'>{$title}</h4><p>{$message}</p><hr>";
    echo "<p class='mb-0'>Por favor, verifica tus credenciales en la <a href='../configuracion.html'>página de configuración</a> y vuelve a intentarlo.</p>";
    echo "</div></div></body></html>";
    exit;
}

// --- 1. Obtener App ID y App Secret de la configuración ---
$pdo = get_db_connection();
$meta_settings = get_meta_settings($pdo);

$app_id = $meta_settings['meta_app_id'] ?? null;
$encrypted_secret = $meta_settings['meta_app_secret'] ?? null;
$app_secret = $encrypted_secret ? decrypt_token($encrypted_secret) : null;

if (!$app_id || !$app_secret) {
    die_with_error_page('Configuración Incompleta', "El 'Meta App ID' o 'Meta App Secret' no están configurados en Platflow.");
}

// --- 2. Validar el 'state' para prevenir ataques CSRF ---
$state_from_session = $_SESSION['meta_oauth_state'] ?? null;
$state_from_fb = $_GET['state'] ?? null;

if (!$state_from_session || !$state_from_fb || $state_from_session !== $state_from_fb) {
    die_with_error_page('Error de Seguridad', 'El estado de la sesión no coincide. La solicitud no es válida.');
}

// Limpiar el state de la sesión
unset($_SESSION['meta_oauth_state']);

// --- 3. Intercambiar el código de autorización por un Access Token ---
$auth_code = $_GET['code'] ?? null;
if (!$auth_code) {
    $error_reason = $_GET['error_reason'] ?? 'desconocida';
    $error_description = $_GET['error_description'] ?? 'No se proporcionó un código de autorización.';
    die_with_error_page("Autorización denegada por el usuario ({$error_reason})", $error_description);
}

$redirect_uri = BASE_URL . '/api/meta_callback.php';

$token_exchange_url = "https://graph.facebook.com/v20.0/oauth/access_token?" . http_build_query([
    'client_id' => $app_id,
    'redirect_uri' => $redirect_uri,
    'client_secret' => $app_secret,
    'code' => $auth_code
]);

$ch = curl_init($token_exchange_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$token_data = json_decode($response, true);

if (isset($token_data['error'])) {
    die_with_error_page('Error al obtener el Access Token', $token_data['error']['message']);
}

$user_access_token = $token_data['access_token'];

// --- 4. Usar el Access Token para obtener las cuentas (páginas) del usuario ---
$accounts_url = "https://graph.facebook.com/v20.0/me/accounts?" . http_build_query([
    'access_token' => $user_access_token,
    'fields' => 'id,name,access_token' // Pedimos el token de acceso específico de cada página
]);

$ch = curl_init($accounts_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$accounts_data = json_decode($response, true);

if (isset($accounts_data['error'])) {
    die_with_error_page('Error al obtener las páginas', $accounts_data['error']['message']);
}

if (empty($accounts_data['data'])) {
    die_with_error_page('No se encontraron páginas', 'Tu cuenta de Facebook no parece administrar ninguna página.');
}

// --- 5. Guardar las páginas en la sesión y redirigir al selector de página ---
$_SESSION['meta_pages'] = $accounts_data['data'];

// Redirigir al usuario a la página de selección.
// Asegúrate de que el archivo meta_select_page.html exista.
header('Location: ../meta_select_page.html');
exit();

?>