<?php
session_start();
require_once __DIR__ . '/../config/db.php';
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../config/config.php'; // Incluir la configuración global

/**
 * Lee la configuración de Meta desde la base de datos.
 * @return array
 */
function get_meta_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'meta_settings'");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    if ($result) {
        return json_decode($result, true);
    }
    return null;
}

// --- 1. Obtener el App ID de la configuración ---
$pdo = get_db_connection();
$meta_settings = get_meta_settings($pdo);

$app_id = $meta_settings['meta_app_id'] ?? null;

if (!$app_id) {
    die("Error: El 'Meta App ID' no está configurado en Platflow. Por favor, ve a Configuración -> Conexiones y guárdalo.");
}

// --- 2. Definir la URL de redirección y los permisos (scopes) ---

// Esta es la URL a la que Facebook redirigirá al usuario después de la autorización.
// Debemos crear este archivo (meta_callback.php) en el siguiente paso.
$redirect_uri = BASE_URL . '/api/meta_callback.php';

// Los permisos que nuestra aplicación solicitará.
$scopes = [
    'pages_show_list',      // Para listar las páginas que administra el usuario
    'pages_manage_posts',   // Para publicar y programar posts
    'pages_read_engagement',// Para leer métricas e insights
    'instagram_basic',      // Para obtener datos básicos de la cuenta de Instagram vinculada
    'instagram_manage_comments', // Para gestionar comentarios (futura función)
    'ads_read'              // Para leer insights de anuncios (futura función)
];
$scope_string = implode(',', $scopes);

// --- 3. Generar y guardar un 'state' para seguridad (prevenir ataques CSRF) ---
$state = bin2hex(random_bytes(16));
$_SESSION['meta_oauth_state'] = $state;

// --- 4. Construir la URL de diálogo de OAuth y redirigir al usuario ---
$facebook_oauth_url = "https://www.facebook.com/v20.0/dialog/oauth?client_id={$app_id}&redirect_uri={$redirect_uri}&state={$state}&scope={$scope_string}";

header('Location: ' . $facebook_oauth_url);
exit();