<?php
session_start();

ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require_once __DIR__ . '/../config/db.php';

$response = ['success' => false, 'message' => 'Credenciales incorrectas.'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if (!empty($email) && !empty($password)) {
        $pdo = get_db_connection();

        if ($pdo) {
            $stmt = $pdo->prepare("SELECT id, nombre_completo, puesto, password FROM professionals WHERE email = ? AND estado = 'Activo'");
            $stmt->execute([$email]);
            $user_found = $stmt->fetch();

            if ($user_found) {
                if (password_verify($password, $user_found['password'])) {
                    $_SESSION['user_id'] = $user_found['id'];
                    $_SESSION['user_name'] = $user_found['nombre_completo'];
                    $_SESSION['user_puesto'] = $user_found['puesto'];
                    
                    $response['success'] = true;
                    $response['message'] = 'Inicio de sesión exitoso.';
                } else {
                    $response['message'] = 'Contraseña incorrecta.';
                }
            } else {
                $response['message'] = 'Usuario no encontrado o inactivo.';
            }
        }
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response);
?>