<?php
header("Content-Type: application/json");

require_once __DIR__ . '/../config/db.php';

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$pdo = get_db_connection();

if ($method === 'GET') {
    if ($id !== null) {
        $stmt = $pdo->prepare("SELECT * FROM invoices WHERE id = ?");
        $stmt->execute([$id]);
        $invoice = $stmt->fetch();
        if ($invoice) {
            $invoice['totals'] = json_decode($invoice['totals'], true);
            echo json_encode($invoice);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Factura no encontrada']);
        }
    } else {
        $stmt = $pdo->query("SELECT i.*, c.nombre_empresa as client_name FROM invoices i JOIN clients c ON i.client_id = c.id ORDER BY i.invoice_date DESC");
        $invoices = $stmt->fetchAll();
        foreach ($invoices as &$invoice) {
            $invoice['totals'] = json_decode($invoice['totals'], true);
        }
        echo json_encode($invoices);
    }
} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        $sql = "INSERT INTO invoices (client_id, invoice_number, invoice_date, due_date, status, totals) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['client_id'],
            $input['invoice_number'],
            $input['invoice_date'],
            $input['due_date'] ?: null,
            $input['status'] ?? 'Pendiente',
            json_encode($input['totals'] ?? [])
        ]);

        $input['id'] = $pdo->lastInsertId();

        http_response_code(201);
        echo json_encode($input);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al crear factura: ' . $e->getMessage()]);
    }

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        $sql = "UPDATE invoices SET client_id=?, invoice_number=?, invoice_date=?, due_date=?, status=?, totals=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['client_id'],
            $input['invoice_number'],
            $input['invoice_date'],
            $input['due_date'] ?: null,
            $input['status'],
            json_encode($input['totals'] ?? []),
            $id
        ]);

        if ($stmt->rowCount()) {
            echo json_encode($input);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Factura no encontrada para actualizar']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al actualizar factura: ' . $e->getMessage()]);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    try {
        $stmt = $pdo->prepare("DELETE FROM invoices WHERE id = ?");
        $stmt->execute([$id]);
        
        if ($stmt->rowCount()) {
            http_response_code(204);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Factura no encontrada']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al eliminar factura: ' . $e->getMessage()]);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>