<?php
header("Content-Type: application/json");

require_once __DIR__ . '/../config/db.php';

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$pdo = get_db_connection();

if ($method === 'GET') {
    if ($id !== null) {
        $stmt = $pdo->prepare("SELECT * FROM expenses WHERE id = ?");
        $stmt->execute([$id]);
        $expense = $stmt->fetch();
        if ($expense) {
            $expense['totals'] = json_decode($expense['totals'], true);
            echo json_encode($expense);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Gasto no encontrado']);
        }
    } else {
        $stmt = $pdo->query("SELECT * FROM expenses ORDER BY expense_date DESC");
        $expenses = $stmt->fetchAll();
        foreach ($expenses as &$expense) {
            $expense['totals'] = json_decode($expense['totals'], true);
        }
        echo json_encode($expenses);
    }
} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        $sql = "INSERT INTO expenses (provider, expense_number, expense_date, due_date, status, totals) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['provider'],
            $input['expense_number'],
            $input['expense_date'],
            $input['due_date'] ?: null,
            $input['status'] ?? 'Pendiente',
            json_encode($input['totals'] ?? [])
        ]);

        $input['id'] = $pdo->lastInsertId();

        http_response_code(201);
        echo json_encode($input);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al crear gasto: ' . $e->getMessage()]);
    }

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        $sql = "UPDATE expenses SET provider=?, expense_number=?, expense_date=?, due_date=?, status=?, totals=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['provider'],
            $input['expense_number'],
            $input['expense_date'],
            $input['due_date'] ?: null,
            $input['status'],
            json_encode($input['totals'] ?? []),
            $id
        ]);

        if ($stmt->rowCount()) {
            echo json_encode($input);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Gasto no encontrado para actualizar']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al actualizar gasto: ' . $e->getMessage()]);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    try {
        $stmt = $pdo->prepare("DELETE FROM expenses WHERE id = ?");
        $stmt->execute([$id]);
        
        if ($stmt->rowCount()) {
            http_response_code(204);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Gasto no encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al eliminar gasto: ' . $e->getMessage()]);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>