<?php
// Backend para gestionar los contactos (CRUD)
header("Content-Type: application/json");
require_once __DIR__ . '/../config/db.php';
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$pdo = get_db_connection();

if ($method === 'GET') {
    if ($id !== null) {
        $stmt = $pdo->prepare("SELECT * FROM contacts WHERE id = ?");
        $stmt->execute([$id]);
        $contact = $stmt->fetch();
        if ($contact) {
            echo json_encode($contact);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Contacto no encontrado']);
        }
    } else {
        // Obtener todos los contactos y unir con la tabla de clientes para obtener el nombre de la empresa
        $stmt = $pdo->query("SELECT co.*, cl.nombre_empresa FROM contacts co LEFT JOIN clients cl ON co.empresa_id = cl.id ORDER BY co.nombre_completo ASC");
        $contacts = $stmt->fetchAll();
        echo json_encode($contacts);
    }
} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    // Validación básica
    if (empty($input['nombre_completo'])) {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'El nombre del contacto es un campo requerido.']);
        exit;
    }
    
    try {
        $sql = "INSERT INTO contacts (empresa_id, nombre_completo, cargo, correo, telefono) VALUES (?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            empty($input['empresa_id']) ? null : (int)$input['empresa_id'],
            $input['nombre_completo'],
            $input['cargo'] ?? '',
            $input['correo'] ?? '',
            $input['telefono'] ?? ''
        ]);

        $new_id = $pdo->lastInsertId();
        
        // Devolver el contacto recién creado
        $stmt = $pdo->prepare("SELECT * FROM contacts WHERE id = ?");
        $stmt->execute([$new_id]);
        $new_contact = $stmt->fetch();

        http_response_code(201);
        echo json_encode($new_contact);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al crear contacto: ' . $e->getMessage()]);
    }

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);

    $sql = "UPDATE contacts SET empresa_id = ?, nombre_completo = ?, cargo = ?, correo = ?, telefono = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        empty($input['empresa_id']) ? null : (int)$input['empresa_id'],
        $input['nombre_completo'],
        $input['cargo'] ?? '',
        $input['correo'] ?? '',
        $input['telefono'] ?? '',
        $id
    ]);

    if ($stmt->rowCount()) {
        // Devolver el contacto actualizado
        $stmt = $pdo->prepare("SELECT * FROM contacts WHERE id = ?");
        $stmt->execute([$id]);
        $updated_contact = $stmt->fetch();
        echo json_encode($updated_contact);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Contacto no encontrado para actualizar']);
    }
} elseif ($method === 'DELETE' && $id !== null) {
    // La tabla `contacts` tiene `ON DELETE CASCADE` en la FK `empresa_id`.
    // Esto significa que si se borra un CLIENTE, sus contactos se borran.
    // Borrar un contacto directamente no tiene restricciones especiales.
    $stmt = $pdo->prepare("DELETE FROM contacts WHERE id = ?");
    $stmt->execute([$id]);
    
    if ($stmt->rowCount()) {
        http_response_code(204);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Contacto no encontrado']);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>
