<?php
// Backend para gestionar los clientes (CRUD)

header("Content-Type: application/json");
ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../api/check_session.php';

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$pdo = get_db_connection();

if ($method === 'GET') {
    if ($id !== null) {
        $stmt = $pdo->prepare("SELECT * FROM clients WHERE id = ?");
        $stmt->execute([$id]);
        $client = $stmt->fetch();
        if ($client) {
            echo json_encode($client);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Cliente no encontrado']);
        }
    } else {
        $stmt = $pdo->query("SELECT * FROM clients ORDER BY nombre_empresa ASC");
        $clients = $stmt->fetchAll();
        echo json_encode($clients);
    }
} elseif ($method === 'POST') {
    // Solo roles autorizados pueden crear
    if (!check_permission('profesionales')) { // Usamos el mismo permiso que para profesionales
        http_response_code(403);
        echo json_encode(['error' => 'No tienes permiso para crear clientes.']);
        exit;
    }

    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        $sql = "INSERT INTO clients (nombre_empresa, razon_social, ruc, telefono, correo, web, direccion, ciudad, pais, estado, link_fb, link_ig, link_in, link_ytb, link_x, link_tiktok) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['nombre_empresa'] ?? '', $input['razon_social'] ?? '', $input['ruc'] ?? '', $input['telefono'] ?? '', $input['correo'] ?? '', $input['web'] ?? '', $input['direccion'] ?? '', $input['ciudad'] ?? '', $input['pais'] ?? '', $input['estado'] ?? 'Activo', $input['link_fb'] ?? '', $input['link_ig'] ?? '', $input['link_in'] ?? '', $input['link_ytb'] ?? '', $input['link_x'] ?? '', $input['link_tiktok'] ?? ''
        ]);
        $input['id'] = $pdo->lastInsertId();

        http_response_code(201);
        echo json_encode($input);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al crear cliente: ' . $e->getMessage()]);
    }

} elseif ($method === 'PUT' && $id !== null) {
    // Solo roles autorizados pueden editar
    if (!check_permission('profesionales')) {
        http_response_code(403);
        echo json_encode(['error' => 'No tienes permiso para editar clientes.']);
        exit;
    }

    try {
        $input = json_decode(file_get_contents('php://input'), true);
        $sql = "UPDATE clients SET nombre_empresa=?, razon_social=?, ruc=?, telefono=?, correo=?, web=?, direccion=?, ciudad=?, pais=?, estado=?, link_fb=?, link_ig=?, link_in=?, link_ytb=?, link_x=?, link_tiktok=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $input['nombre_empresa'], $input['razon_social'], $input['ruc'], $input['telefono'], $input['correo'], $input['web'], $input['direccion'], $input['ciudad'], $input['pais'], $input['estado'], $input['link_fb'], $input['link_ig'], $input['link_in'], $input['link_ytb'], $input['link_x'], $input['link_tiktok'], $id
        ]);
        if ($stmt->rowCount()) {
            echo json_encode($input);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Cliente no encontrado para actualizar']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al actualizar cliente: ' . $e->getMessage()]);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    // Solo roles autorizados pueden eliminar
    if (!check_permission('profesionales')) {
        http_response_code(403);
        echo json_encode(['error' => 'No tienes permiso para eliminar clientes.']);
        exit;
    }

    try {
        // Prevenir borrado si tiene proyectos asociados
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM projects WHERE cliente_id = ?");
        $stmt->execute([$id]);
        if ($stmt->fetchColumn() > 0) {
            http_response_code(409); // 409 Conflict es un buen código para esta situación
            echo json_encode(['error' => 'No se puede eliminar el cliente porque tiene proyectos asociados.']);
            exit;
        }

        $stmt = $pdo->prepare("DELETE FROM clients WHERE id = ?");
        $stmt->execute([$id]);

        if ($stmt->rowCount()) {
            http_response_code(204);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Cliente no encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al eliminar cliente: ' . $e->getMessage()]);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}

?>
