<?php
session_start();
require_once __DIR__ . '/../config/config.php'; // Cargar la URL base

// --- CONFIGURACIÓN CENTRALIZADA DE ROLES Y PERMISOS ---
$roles_config = [
    'finanzas' => ['Director de Cuentas', 'Director Creativo', 'Key Account Manager', 'Administrador'],
    'profesionales' => ['Director de Cuentas', 'Director Creativo', 'Key Account Manager', 'Administrador'],
    // Añadir más secciones y roles permitidos aquí si es necesario
];

/**
 * Verifica si el rol del usuario actual tiene permiso para una sección.
 * @param string $section La clave de la sección a verificar (ej: 'finanzas').
 * @return bool True si tiene permiso, false si no.
 */
function check_permission($section) {
    global $roles_config;
    $user_role = $_SESSION['user_puesto'] ?? '';
    return isset($roles_config[$section]) && in_array($user_role, $roles_config[$section]);
}

if (!isset($_SESSION['user_id'])) {
    // Si no es una petición AJAX, redirigir
    if (empty($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
        header('Location: ' . BASE_URL . '/login.php');
        exit();
    } else {
        // Si es una petición AJAX, devolver un error
        header('Content-Type: application/json'); // Asegurar cabecera JSON
        echo json_encode(['success' => false, 'message' => 'No autenticado', 'action' => 'redirect']);
        exit();
    }
}