<?php
header('Content-Type: application/json');

ini_set('display_errors', 1); // Mostrar errores para depuración
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// --- INICIO DEL SCRIPT PRINCIPAL ---

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido en analizar_datos.php.']);
    exit;
}

// Este endpoint ahora actúa como un proxy hacia el manejador central de IA.
// Prepara los datos y los reenvía.
$ch = curl_init('http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/ai_handler.php');

$post_data = [
    'task_type' => 'analyze_data',
    'context' => json_encode(['prompt' => $_POST['prompt'] ?? ''])
];

// Adjuntar archivos si existen
if (isset($_FILES['data_files'])) {
    foreach ($_FILES['data_files']['tmp_name'] as $key => $tmp_name) {
        if (!empty($tmp_name) && is_uploaded_file($tmp_name)) {
            $post_data['data_files['.$key.']'] = new CURLFile($tmp_name, $_FILES['data_files']['type'][$key], $_FILES['data_files']['name'][$key]);
        }
    }
}

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error interno al reenviar la solicitud: ' . $error]);
    exit;
}

http_response_code($http_code);
$api_result = json_decode($response, true);

if ($http_code === 200 && isset($api_result['report_html'])) {
    echo json_encode([
        'success' => true,
        'message' => 'Análisis completado con éxito.',
        'data' => [
            'report_html' => $api_result['report_html']
        ]
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => $api_result['error'] ?? 'Error desconocido desde el manejador de IA.'
    ]);
}

?>