# Guía de Usuario de Platflow

¡Bienvenido a Platflow! Esta guía te ayudará a familiarizarte con las principales funciones de la plataforma para que puedas empezar a gestionar tus proyectos de marketing de manera eficiente.

## 1. Primeros Pasos

Al iniciar sesión, lo primero que verás es el **Dashboard**. Antes de empezar a crear proyectos, te recomendamos realizar dos acciones:

1.  **Añadir Profesionales:** Ve a la sección **Profesionales** y registra a todos los miembros de tu equipo. Esto es crucial para poder asignarles tareas y responsabilidades más adelante.
2.  **Añadir Clientes:** Ve a la sección **Clientes** y registra a las empresas con las que trabajas. No podrás crear un proyecto si no tienes al menos un cliente registrado.

## 2. Secciones Principales

La barra de navegación lateral te da acceso a todas las secciones de Platflow.

### Dashboard

Es tu centro de control principal. Aquí encontrarás:
- **Tarjetas de KPIs:** Un resumen rápido de proyectos activos, tareas pendientes y tareas vencidas.
- **Listas Rápidas:** "Proyectos Recientes" y "Tareas Próximas a Vencer" para un acceso directo.
- **Calendario General:** Una vista combinada de las fechas de finalización de proyectos y tareas.

### Profesionales

Gestiona a tu equipo.
- **Añadir Profesional:** Haz clic en "Añadir Profesional", completa los datos (nombre, puesto, email, contraseña) y guarda.
- **Editar/Eliminar:** Usa los botones de acción en la tabla para modificar datos o eliminar a un usuario.

> **Nota:** Solo los usuarios con roles de gestión (Director, KAM, Administrador) pueden acceder a esta sección.

### Clientes

Administra tu cartera de clientes y sus contactos.
- **Pestaña "Gestión de Clientes":** Añade, edita o elimina las empresas para las que trabajas.
- **Pestaña "Gestión de Contactos":** Añade personas de contacto y vincúlalas a una empresa existente.
- **Ver Detalles:** Haz clic en el icono del ojo (<i class="bi bi-eye-fill"></i>) para ver una ficha completa del cliente, incluyendo sus contactos y proyectos asociados.

### Proyectos

El corazón de tu gestión.
- **Crear un Proyecto:** Haz clic en "Abrir Nuevo Proyecto".
    1.  Asigna un nombre y selecciona un cliente.
    2.  Define las fechas, el tipo de marketing y el estado.
    3.  Asigna los profesionales que trabajarán en él.
    4.  **Generar Estrategia con IA (Opcional):** Describe las necesidades del proyecto y haz clic en "Generar con IA" para que el sistema proponga una estrategia de marketing.
    5.  Guarda el proyecto.
- **Acceder a un Proyecto:** Haz clic en el nombre de cualquier proyecto en la tabla para ir a su página de detalles.

### Detalle del Proyecto

Una vez dentro de un proyecto, tendrás acceso a varias pestañas:

- **Tareas:** Añade, edita y elimina tareas. Haz clic en el nombre de una tarea para abrir un modal con más detalles, donde puedes añadir comentarios, archivos, etiquetas y enlaces.
- **Kanban:** Visualiza las tareas en un tablero de "Por Hacer", "En Progreso" y "Hecho". Puedes arrastrar y soltar las tareas entre columnas para actualizar su estado.
- **Gantt:** Observa la línea de tiempo de tus tareas en un diagrama de Gantt interactivo.
- **Grillas:** Gestiona las grillas de contenido para redes sociales.
    - **Crear Grilla:** Define un nombre, un rango de fechas y las redes sociales que se usarán.
    - **Abrir Editor:** Haz clic en "Abrir Editor" en una grilla para empezar a planificar los posteos.
- **Planes de Medios:** Gestiona las pautas en medios tradicionales.
    - **Crear Plan:** Define un nombre, fechas y presupuesto.
    - **Abrir Editor:** Haz clic en "Abrir Editor" para añadir líneas de pauta (TV, radio, etc.).

### Editorial de Redes

Esta sección te da una vista general de todas las grillas de contenido de todos los proyectos.
- **Navegación:** Las grillas están agrupadas por proyecto en un formato de acordeón.
- **Acceso Rápido:** Haz clic en el nombre de una grilla para ir directamente a su editor.

#### Editor de Grilla

- **Añadir Post Manual:** Abre un modal para detallar un posteo (copy, objetivo, CTA, etc.).
- **Generar Posts con IA:** Usa el botón para que la IA sugiera ideas de posteos basadas en la estrategia del proyecto.
- **Generar Activo Creativo:** Dentro del modal de un posteo, usa el botón de IA para generar un prompt para una imagen o un guion para un video.

### Plan de Medios

Esta sección te permite acceder a los planes de medios de cualquier proyecto.
- **Seleccionar Proyecto:** Haz clic en un proyecto de la lista para ir a su página de detalles, donde podrás gestionar sus planes.

#### Editor de Plan de Medios

- **Resumen de Presupuesto:** Visualiza cuánto del presupuesto total has asignado.
- **Añadir Línea:** Registra cada pauta individual (canal, medio, formato, presupuesto, etc.) a través del modal.

### Finanzas

Lleva un control de los ingresos y egresos.
- **Pestaña "Facturas de Venta":** Registra las facturas emitidas a tus clientes.
- **Pestaña "Gastos y Compras":** Registra las facturas de proveedores o gastos generales.
- **Cambiar Estado:** Haz clic en la etiqueta de estado ("Pendiente", "Pagada") para cambiarlo rápidamente.

> **Nota:** Solo los usuarios con roles de gestión pueden acceder a esta sección.

### Todas las Tareas

Una vista global de todas las tareas de todos los proyectos.
- **Filtros Avanzados:** Utiliza los menús desplegables para encontrar tareas por proyecto, profesional, prioridad o estado (pendiente, completada, vencida).
- **Acceso Rápido:** Haz clic en el nombre de una tarea para ir directamente a la página de detalles del proyecto correspondiente.

### Agendas

Visualiza la planificación de la agencia en calendarios interactivos.
- **Agenda de Tareas:** Muestra las fechas de vencimiento de todas las tareas.
- **Agenda Editorial:** Muestra todos los posteos programados.
- **Agenda de Proyectos:** Muestra las líneas de tiempo (inicio y fin) de todos los proyectos.
- **Agenda de Plan de Medios:** Muestra las pautas de medios tradicionales.

### Herramientas Avanzadas (Roles de Gestión)

#### Analizar Datos

Usa la IA para analizar datos y generar reportes.
1.  **Sube Archivos:** Adjunta uno o más archivos (CSV, XLSX, PDF, etc.).
2.  **Escribe tu Solicitud:** Describe qué análisis necesitas (ej: "Crea un gráfico de barras con las ventas por región").
3.  **Genera y Descarga:** Haz clic en "Generar Reporte". El resultado aparecerá en pantalla y podrás descargarlo como un archivo HTML.

#### Meta Dashboard

Visualiza las métricas de tu página de Facebook conectada.
- **Filtra por Fecha:** Selecciona un rango de fechas para analizar.
- **KPIs Comparativos:** Observa el rendimiento de tus fans, interacciones e impresiones comparado con el período anterior.
- **Gráficos Interactivos:** Analiza la evolución de métricas, la distribución de fans por país y las publicaciones con mayor interacción.

> **Nota:** Para usar esta función, un administrador debe conectar la cuenta de Meta en la sección de **Configuración**.

### Configuración (Solo Administradores)

Aquí puedes configurar los parámetros globales de la aplicación.
- **Datos de la Empresa:** Información que se usará en reportes y facturas.
- **IA:** Ingresa tu clave API de Google Gemini (u otro proveedor) para activar las funciones de IA.
- **Conexiones:** Ingresa las credenciales de tu App de Meta for Developers y sigue los pasos para conectar una página de Facebook.

### Chat Global

Comunícate con tu equipo en tiempo real.
- **Abrir Chat:** Haz clic en el botón azul en la esquina inferior derecha de cualquier página.
- **Nueva Conversación:** Inicia un chat individual con un colega o crea un grupo.

---

*¡Disfruta usando Platflow!*