-- LexiPro Database Schema
-- Version 1.0.0
-- ================================================

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- ================================================
-- CONFIGURACIÓN
-- ================================================
CREATE TABLE `configuracion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_empresa` varchar(255) NOT NULL DEFAULT 'LexiPro',
  `ruc` varchar(50) DEFAULT NULL,
  `direccion` text,
  `telefono` varchar(50) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `ciudad` varchar(100) DEFAULT 'Asunción',
  `pais` varchar(100) DEFAULT 'Paraguay',
  `logo` varchar(255) DEFAULT NULL,
  `timbrado` varchar(50) DEFAULT NULL,
  `establecimiento` varchar(10) DEFAULT '001',
  `punto_expedicion` varchar(10) DEFAULT '001',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `configuracion` (`id`, `nombre_empresa`) VALUES (1, 'LexiPro');

-- ================================================
-- ROLES Y PERMISOS
-- ================================================
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text,
  `nivel` int(11) NOT NULL DEFAULT '0',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `roles` (`id`, `nombre`, `descripcion`, `nivel`) VALUES
(1, 'Administrador', 'Acceso completo al sistema', 100),
(2, 'Abogado Senior', 'Gestión completa de casos', 80),
(3, 'Abogado Junior', 'Gestión limitada de casos', 60),
(4, 'Notario', 'Gestión de documentos notariales', 70),
(5, 'Actuario', 'Gestión de trámites judiciales', 50),
(6, 'Secretario', 'Gestión administrativa', 40),
(7, 'Oficial', 'Gestión de diligencias', 30),
(8, 'Gestor', 'Gestión de cobros', 20);

CREATE TABLE `modulos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `descripcion` text,
  `icono` varchar(50) DEFAULT NULL,
  `orden` int(11) NOT NULL DEFAULT '0',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `modulos` (`nombre`, `slug`, `icono`, `orden`) VALUES
('Casos', 'casos', '⚖️', 1),
('Clientes', 'clientes', '👥', 2),
('Agenda', 'agenda', '📅', 3),
('Tareas', 'tareas', '✓', 4),
('Chat', 'chat', '💬', 5),
('Facturación', 'facturacion', '💰', 6),
('Compras', 'compras', '🛒', 7),
('Proveedores', 'proveedores', '🏢', 8),
('Contabilidad', 'contabilidad', '📊', 9),
('Honorarios', 'rrhh', '💼', 10),
('Asistente IA', 'ia', '🤖', 11),
('Biblioteca', 'biblioteca', '📚', 12),
('Reportes', 'reportes', '📈', 13),
('Archivos', 'archivos', '📁', 14),
('Usuarios', 'usuarios', '👤', 15),
('Configuración', 'configuracion', '⚙️', 16);

CREATE TABLE `permisos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rol_id` int(11) NOT NULL,
  `modulo_id` int(11) NOT NULL,
  `ver` tinyint(1) NOT NULL DEFAULT '0',
  `crear` tinyint(1) NOT NULL DEFAULT '0',
  `editar` tinyint(1) NOT NULL DEFAULT '0',
  `eliminar` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `rol_modulo` (`rol_id`,`modulo_id`),
  KEY `modulo_id` (`modulo_id`),
  CONSTRAINT `permisos_ibfk_1` FOREIGN KEY (`rol_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permisos_ibfk_2` FOREIGN KEY (`modulo_id`) REFERENCES `modulos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Permisos para Administrador (todos)
INSERT INTO `permisos` (`rol_id`, `modulo_id`, `ver`, `crear`, `editar`, `eliminar`)
SELECT 1, `id`, 1, 1, 1, 1 FROM `modulos`;

-- ================================================
-- USUARIOS
-- ================================================
CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `usuario` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `foto` varchar(255) DEFAULT NULL,
  `rol_id` int(11) NOT NULL,
  `tipo_pago` enum('por_hora','mensual') DEFAULT 'mensual',
  `tarifa_hora` decimal(10,2) DEFAULT NULL,
  `salario_mensual` decimal(10,2) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `ultimo_acceso` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `usuario` (`usuario`),
  UNIQUE KEY `email` (`email`),
  KEY `rol_id` (`rol_id`),
  CONSTRAINT `usuarios_ibfk_1` FOREIGN KEY (`rol_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- CLIENTES
-- ================================================
CREATE TABLE `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) DEFAULT NULL,
  `razon_social` varchar(255) DEFAULT NULL,
  `tipo_documento` enum('CI','RUC','Pasaporte','Otro') DEFAULT 'CI',
  `numero_documento` varchar(50) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `celular` varchar(50) DEFAULT NULL,
  `direccion` text,
  `ciudad` varchar(100) DEFAULT NULL,
  `pais` varchar(100) DEFAULT 'Paraguay',
  `fecha_nacimiento` date DEFAULT NULL,
  `ocupacion` varchar(100) DEFAULT NULL,
  `estado_civil` enum('Soltero','Casado','Divorciado','Viudo','Unión Libre') DEFAULT NULL,
  `foto` varchar(255) DEFAULT NULL,
  `notas` text,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `numero_documento` (`numero_documento`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `clientes_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- CASOS
-- ================================================
CREATE TABLE `casos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero_caso` varchar(50) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_caso` varchar(100) DEFAULT NULL,
  `materia` varchar(100) DEFAULT NULL,
  `juzgado` varchar(255) DEFAULT NULL,
  `expediente` varchar(100) DEFAULT NULL,
  `demandante` varchar(255) DEFAULT NULL,
  `demandado` varchar(255) DEFAULT NULL,
  `monto_estimado` decimal(15,2) DEFAULT NULL,
  `honorarios` decimal(15,2) DEFAULT NULL,
  `estado` enum('abierto','en_proceso','suspendido','cerrado','archivado') NOT NULL DEFAULT 'abierto',
  `prioridad` enum('baja','media','alta','urgente') NOT NULL DEFAULT 'media',
  `fecha_inicio` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `fecha_cierre` date DEFAULT NULL,
  `responsable_id` int(11) DEFAULT NULL,
  `descripcion` text,
  `notas_internas` text,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `numero_caso` (`numero_caso`),
  KEY `cliente_id` (`cliente_id`),
  KEY `responsable_id` (`responsable_id`),
  KEY `estado` (`estado`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `casos_ibfk_1` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `casos_ibfk_2` FOREIGN KEY (`responsable_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL,
  CONSTRAINT `casos_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `casos_usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caso_id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `rol_en_caso` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `caso_usuario` (`caso_id`,`usuario_id`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `casos_usuarios_ibfk_1` FOREIGN KEY (`caso_id`) REFERENCES `casos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `casos_usuarios_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- TAREAS
-- ================================================
CREATE TABLE `tareas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caso_id` int(11) DEFAULT NULL,
  `titulo` varchar(255) NOT NULL,
  `descripcion` text,
  `responsable_id` int(11) DEFAULT NULL,
  `estado` enum('pendiente','en_curso','completada','cancelada') NOT NULL DEFAULT 'pendiente',
  `prioridad` enum('baja','media','alta','urgente') NOT NULL DEFAULT 'media',
  `es_plazo_juridico` tinyint(1) NOT NULL DEFAULT '0',
  `fecha_limite` datetime DEFAULT NULL,
  `fecha_completada` datetime DEFAULT NULL,
  `horas_estimadas` decimal(5,2) DEFAULT NULL,
  `horas_trabajadas` decimal(5,2) DEFAULT NULL,
  `notas` text,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `caso_id` (`caso_id`),
  KEY `responsable_id` (`responsable_id`),
  KEY `estado` (`estado`),
  KEY `fecha_limite` (`fecha_limite`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `tareas_ibfk_1` FOREIGN KEY (`caso_id`) REFERENCES `casos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tareas_ibfk_2` FOREIGN KEY (`responsable_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tareas_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- AGENDA
-- ================================================
CREATE TABLE `agenda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) NOT NULL,
  `descripcion` text,
  `tipo` enum('audiencia','reunion','cita','plazo','otro') NOT NULL DEFAULT 'otro',
  `caso_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) NOT NULL,
  `ubicacion` varchar(255) DEFAULT NULL,
  `fecha_inicio` datetime NOT NULL,
  `fecha_fin` datetime DEFAULT NULL,
  `todo_el_dia` tinyint(1) NOT NULL DEFAULT '0',
  `recordatorio` int(11) DEFAULT NULL COMMENT 'Minutos antes',
  `color` varchar(20) DEFAULT NULL,
  `notas` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `caso_id` (`caso_id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `fecha_inicio` (`fecha_inicio`),
  CONSTRAINT `agenda_ibfk_1` FOREIGN KEY (`caso_id`) REFERENCES `casos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `agenda_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- ARCHIVOS
-- ================================================
CREATE TABLE `archivos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_original` varchar(255) NOT NULL,
  `nombre_archivo` varchar(255) NOT NULL,
  `ruta` varchar(500) NOT NULL,
  `tipo_mime` varchar(100) DEFAULT NULL,
  `tamanio` bigint(20) DEFAULT NULL,
  `modulo` varchar(50) NOT NULL,
  `modulo_id` int(11) NOT NULL,
  `categoria` varchar(100) DEFAULT NULL,
  `descripcion` text,
  `uploaded_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `modulo` (`modulo`,`modulo_id`),
  KEY `uploaded_by` (`uploaded_by`),
  CONSTRAINT `archivos_ibfk_1` FOREIGN KEY (`uploaded_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- FACTURACIÓN
-- ================================================
CREATE TABLE `facturas_ventas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero_factura` varchar(50) NOT NULL,
  `tipo` enum('contado','credito') NOT NULL DEFAULT 'contado',
  `cliente_id` int(11) NOT NULL,
  `caso_id` int(11) DEFAULT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `timbrado` varchar(50) DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL DEFAULT '0.00',
  `iva_5` decimal(15,2) NOT NULL DEFAULT '0.00',
  `iva_10` decimal(15,2) NOT NULL DEFAULT '0.00',
  `exentas` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total` decimal(15,2) NOT NULL DEFAULT '0.00',
  `estado` enum('pendiente','pagada','anulada') NOT NULL DEFAULT 'pendiente',
  `notas` text,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `numero_factura` (`numero_factura`),
  KEY `cliente_id` (`cliente_id`),
  KEY `caso_id` (`caso_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `facturas_ventas_ibfk_1` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `facturas_ventas_ibfk_2` FOREIGN KEY (`caso_id`) REFERENCES `casos` (`id`) ON DELETE SET NULL,
  CONSTRAINT `facturas_ventas_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `facturas_ventas_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `factura_id` int(11) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `cantidad` decimal(10,2) NOT NULL DEFAULT '1.00',
  `precio_unitario` decimal(15,2) NOT NULL,
  `iva` enum('exenta','5','10') NOT NULL DEFAULT '10',
  `subtotal` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `factura_id` (`factura_id`),
  CONSTRAINT `facturas_ventas_detalle_ibfk_1` FOREIGN KEY (`factura_id`) REFERENCES `facturas_ventas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- PROVEEDORES
-- ================================================
CREATE TABLE `proveedores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `ruc` varchar(50) DEFAULT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `direccion` text,
  `ciudad` varchar(100) DEFAULT NULL,
  `contacto` varchar(255) DEFAULT NULL,
  `notas` text,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `facturas_compras` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero_factura` varchar(50) NOT NULL,
  `proveedor_id` int(11) NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `timbrado` varchar(50) DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL DEFAULT '0.00',
  `iva_5` decimal(15,2) NOT NULL DEFAULT '0.00',
  `iva_10` decimal(15,2) NOT NULL DEFAULT '0.00',
  `exentas` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total` decimal(15,2) NOT NULL DEFAULT '0.00',
  `estado` enum('pendiente','pagada','anulada') NOT NULL DEFAULT 'pendiente',
  `categoria_gasto` varchar(100) DEFAULT NULL,
  `notas` text,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `proveedor_id` (`proveedor_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `facturas_compras_ibfk_1` FOREIGN KEY (`proveedor_id`) REFERENCES `proveedores` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `facturas_compras_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- CONTABILIDAD
-- ================================================
CREATE TABLE `plan_cuentas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  `tipo` enum('activo','pasivo','patrimonio','ingreso','gasto') NOT NULL,
  `nivel` int(11) NOT NULL,
  `padre_id` int(11) DEFAULT NULL,
  `activa` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `padre_id` (`padre_id`),
  CONSTRAINT `plan_cuentas_ibfk_1` FOREIGN KEY (`padre_id`) REFERENCES `plan_cuentas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `asientos_contables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero_asiento` varchar(50) NOT NULL,
  `fecha` date NOT NULL,
  `descripcion` text NOT NULL,
  `modulo` varchar(50) DEFAULT NULL,
  `modulo_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `numero_asiento` (`numero_asiento`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `asientos_contables_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `asientos_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asiento_id` int(11) NOT NULL,
  `cuenta_id` int(11) NOT NULL,
  `debe` decimal(15,2) NOT NULL DEFAULT '0.00',
  `haber` decimal(15,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `asiento_id` (`asiento_id`),
  KEY `cuenta_id` (`cuenta_id`),
  CONSTRAINT `asientos_detalle_ibfk_1` FOREIGN KEY (`asiento_id`) REFERENCES `asientos_contables` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asientos_detalle_ibfk_2` FOREIGN KEY (`cuenta_id`) REFERENCES `plan_cuentas` (`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- CHAT
-- ================================================
CREATE TABLE `chat_interno` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emisor_id` int(11) NOT NULL,
  `receptor_id` int(11) NOT NULL,
  `mensaje` text NOT NULL,
  `caso_id` int(11) DEFAULT NULL,
  `archivo` varchar(255) DEFAULT NULL,
  `leido` tinyint(1) NOT NULL DEFAULT '0',
  `fecha_leido` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `emisor_id` (`emisor_id`),
  KEY `receptor_id` (`receptor_id`),
  KEY `caso_id` (`caso_id`),
  CONSTRAINT `chat_interno_ibfk_1` FOREIGN KEY (`emisor_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_interno_ibfk_2` FOREIGN KEY (`receptor_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_interno_ibfk_3` FOREIGN KEY (`caso_id`) REFERENCES `casos` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `chat_web` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `mensaje` text NOT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `user_agent` varchar(500) DEFAULT NULL,
  `atendido_por` int(11) DEFAULT NULL,
  `estado` enum('nuevo','en_atencion','resuelto','cerrado') NOT NULL DEFAULT 'nuevo',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `atendido_por` (`atendido_por`),
  CONSTRAINT `chat_web_ibfk_1` FOREIGN KEY (`atendido_por`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- BIBLIOTECA JURÍDICA
-- ================================================
CREATE TABLE `biblioteca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('ley','decreto','jurisprudencia','doctrina','formulario','otro') NOT NULL,
  `titulo` varchar(500) NOT NULL,
  `numero` varchar(100) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `descripcion` text,
  `contenido` longtext,
  `archivo` varchar(255) DEFAULT NULL,
  `tags` text,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `tipo` (`tipo`),
  KEY `created_by` (`created_by`),
  FULLTEXT KEY `busqueda` (`titulo`,`descripcion`,`contenido`,`tags`),
  CONSTRAINT `biblioteca_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- NOTIFICACIONES
-- ================================================
CREATE TABLE `notificaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `mensaje` text,
  `url` varchar(500) DEFAULT NULL,
  `leida` tinyint(1) NOT NULL DEFAULT '0',
  `fecha_leida` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `leida` (`leida`),
  CONSTRAINT `notificaciones_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ================================================
-- LOG DE ACTIVIDADES
-- ================================================
CREATE TABLE `actividades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `accion` varchar(100) NOT NULL,
  `modulo` varchar(50) NOT NULL,
  `modulo_id` int(11) DEFAULT NULL,
  `descripcion` text,
  `ip_address` varchar(50) DEFAULT NULL,
  `user_agent` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `modulo` (`modulo`,`modulo_id`),
  CONSTRAINT `actividades_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS=1;
COMMIT;