<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro - Bridgi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex flex-column min-vh-100 bg-light">
    <div class="container my-auto d-flex justify-content-center align-items-center py-4">
        <div class="card" style="width: 25rem;">
            <div class="card-body">
                <h3 class="card-title text-center mb-4">Crear Cuenta</h3>
                <div id="alert-placeholder"></div>
                <form id="register-form">
                    <div class="mb-3">
                        <label for="nombrecompleto" class="form-label">Nombre Completo</label>
                        <input type="text" class="form-control" id="nombrecompleto" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="username" class="form-label">Nombre de Usuario</label>
                            <input type="text" class="form-control" id="username" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="password" class="form-label">Contraseña</label>
                            <input type="password" class="form-control" id="password" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="documento" class="form-label">Documento</label>
                        <input type="text" class="form-control" id="documento">
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Correo Electrónico</label>
                        <input type="email" class="form-control" id="email" required>
                    </div>
                     <div class="mb-3">
                        <label for="telefono" class="form-label">Teléfono Móvil</label>
                        <input type="text" class="form-control" id="telefono">
                    </div>
                    <div class="mb-3">
                        <label for="direccion" class="form-label">Dirección</label>
                        <input type="text" class="form-control" id="direccion">
                    </div>
                    <div class="mb-3">
                        <label for="categoria" class="form-label">Categoría</label>
                        <select class="form-select" id="categoria" required>
                            <option value="Administrador">Administrador</option>
                            <option value="Contador">Contador</option>
                            <option value="Digitador" selected>Digitador</option>
                        </select>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">Registrarse</button>
                    </div>
                </form>
                <div class="text-center mt-3">
                    <a href="login.php">¿Ya tienes cuenta? Inicia Sesión</a>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center text-muted py-3">
        Bridgi "El Puente Contable". Dunamis Group 2025.
    </footer>

    <script>
        document.getElementById('register-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            const nombrecompleto = document.getElementById('nombrecompleto').value;
            const documento = document.getElementById('documento').value;
            const email = document.getElementById('email').value;
            const telefono = document.getElementById('telefono').value;
            const direccion = document.getElementById('direccion').value;
            const categoria = document.getElementById('categoria').value;
            const alertPlaceholder = document.getElementById('alert-placeholder');

            const response = await fetch('../api.php?action=register', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ 
                    username, 
                    password,
                    nombrecompleto,
                    documento,
                    email,
                    telefono,
                    direccion,
                    ciudad: '', // Campo no solicitado en este form
                    pais: '', // Campo no solicitado en este form
                    categoria 
                })
            });

            const result = await response.json();
            if (response.ok && result.success) {
                alertPlaceholder.innerHTML = '<div class="alert alert-success" role="alert">¡Registro exitoso! Ahora puedes iniciar sesión.</div>';
                setTimeout(() => { window.location.href = 'login.php'; }, 2000);
            } else {
                alertPlaceholder.innerHTML = `<div class="alert alert-danger" role="alert">${result.error || 'Error desconocido.'}</div>`;
            }
        });
    </script>
</body>
</html>