<?php
session_start();
// Redirigir si el usuario no ha iniciado sesión
if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendario de Vencimientos - Bridgi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FullCalendar JS -->
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js'></script>
    <style>
        /* Estilos para que el calendario se vea bien */
        #calendar {
            max-width: 1100px;
            margin: 0 auto;
        }
        .fc-event {
            cursor: pointer;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center" href="index.html">
                <img src="Images/logoblanco.png" alt="Bridgi Logo" height="30" class="me-2">
                Bridgi
            </a>
             <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <?php if ($_SESSION['categoria'] === 'Administrador'): ?>
                    <li class="nav-item"><a class="nav-link" href="users.php">Gestión de Usuarios</a></li>
                <?php endif; ?>
                <?php if ($_SESSION['categoria'] !== 'Digitador'): ?>
                    <li class="nav-item"><a class="nav-link active" href="vencimientos.php">Calendario de Vencimientos</a></li>
                <?php endif; ?>
            </ul>
            <div class="ms-auto">
                <span class="navbar-text me-3 text-white">Usuario: <?php echo htmlspecialchars($_SESSION['username']); ?></span>
                <a href="../api.php?action=logout" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <main class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Calendario de Vencimientos de Timbrados</h4>
                <h4 class="mb-0">Calendario de Vencimientos</h4>
            </div>
            <div class="card-body">
                <div id='calendar'></div>
            </div>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const calendarEl = document.getElementById('calendar');
            const calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'es',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay,listYear'
                },
                buttonText: {
                    today:    'Hoy',
                    month:    'Mes',
                    week:     'Semana',
                    day:      'Día',
                    listYear: 'Año'
                },
                events: '../api.php?action=get_vencimientos',
                eventClick: function(info) {
                    // Prevenir el comportamiento por defecto
                    info.jsEvent.preventDefault(); 
                    if (info.event.url) {
                        window.open(info.event.url, '_blank');
                    }
                }
            });
            calendar.render();
        });
    </script>
</body>
</html>