-- Esquema de Base de Datos para Bridgi
-- Sistema de Contabilidad

-- Tabla de usuarios
CREATE TABLE IF NOT EXISTS users (
    id VARCHAR(20) PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    nombrecompleto VARCHAR(100),
    documento VARCHAR(50),
    email VARCHAR(100),
    telefono VARCHAR(20),
    direccion VARCHAR(200),
    ciudad VARCHAR(100),
    pais VARCHAR(100),
    categoria ENUM('Administrador', 'Contador', 'Digitador') DEFAULT 'Digitador',
    remember_token VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de empresas
CREATE TABLE IF NOT EXISTS empresas (
    id VARCHAR(20) PRIMARY KEY,
    nombre VARCHAR(200) NOT NULL,
    ruc VARCHAR(50) NOT NULL,
    tipo ENUM('fisica', 'juridica') DEFAULT 'fisica',
    responsable_contabilidad VARCHAR(100),
    telefono VARCHAR(20),
    direccion VARCHAR(200),
    ciudad VARCHAR(100),
    pais VARCHAR(100),
    actividad_economica TEXT,
    observaciones TEXT,
    logo VARCHAR(255),
    contador_id VARCHAR(20),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (contador_id) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de digitadores asignados a empresas
CREATE TABLE IF NOT EXISTS empresa_digitadores (
    empresa_id VARCHAR(20),
    digitador_id VARCHAR(20),
    PRIMARY KEY (empresa_id, digitador_id),
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
    FOREIGN KEY (digitador_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de timbrados
CREATE TABLE IF NOT EXISTS timbrados (
    id INT AUTO_INCREMENT PRIMARY KEY,
    empresa_id VARCHAR(20),
    numero VARCHAR(50) NOT NULL,
    fecha_inicio DATE NOT NULL,
    fecha_fin DATE NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de presentaciones fiscales
CREATE TABLE IF NOT EXISTS presentaciones_fiscales (
    id INT AUTO_INCREMENT PRIMARY KEY,
    empresa_id VARCHAR(20) UNIQUE,
    iva_dia INT,
    irp_dia INT,
    irp_mes INT,
    irp_periodo VARCHAR(20),
    ire_dia INT,
    ire_mes INT,
    ire_periodo VARCHAR(20),
    inf_dia INT,
    inf_mes INT,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla del plan de cuentas
CREATE TABLE IF NOT EXISTS plan_cuentas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    empresa_id VARCHAR(20),
    codigo VARCHAR(20) NOT NULL,
    nombre VARCHAR(200) NOT NULL,
    tipo ENUM('titulo', 'detalle') DEFAULT 'detalle',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_empresa_codigo (empresa_id, codigo),
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de asientos contables
CREATE TABLE IF NOT EXISTS asientos (
    id VARCHAR(20) PRIMARY KEY,
    empresa_id VARCHAR(20),
    fecha DATE NOT NULL,
    comprobante_nro VARCHAR(50),
    descripcion TEXT,
    ruc_cliente_proveedor VARCHAR(50),
    timbrado VARCHAR(50),
    tipo_comprobante VARCHAR(50),
    condicion_operacion ENUM('contado', 'credito') DEFAULT 'contado',
    es_electronica BOOLEAN DEFAULT FALSE,
    moneda VARCHAR(10) DEFAULT 'PYG',
    tipo_factura ENUM('venta', 'compra', 'manual'),
    iva_tipo INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
    INDEX idx_fecha (fecha),
    INDEX idx_tipo_factura (tipo_factura)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de movimientos contables
CREATE TABLE IF NOT EXISTS movimientos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    asiento_id VARCHAR(20),
    cuenta_codigo VARCHAR(20) NOT NULL,
    descripcion VARCHAR(200),
    debe DECIMAL(15,2) DEFAULT 0,
    haber DECIMAL(15,2) DEFAULT 0,
    FOREIGN KEY (asiento_id) REFERENCES asientos(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de configuración del sistema
CREATE TABLE IF NOT EXISTS configuracion (
    id INT AUTO_INCREMENT PRIMARY KEY,
    clave VARCHAR(50) UNIQUE NOT NULL,
    valor TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de registro de actividad
CREATE TABLE IF NOT EXISTS activity_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50),
    action TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar plan de cuentas por defecto (se usará al crear cada empresa)
-- Este plan será copiado para cada nueva empresa en el código PHP

-- Insertar configuración inicial
INSERT INTO configuracion (clave, valor) VALUES 
('ai_api_key', ''),
('sistema_instalado', 'true')
ON DUPLICATE KEY UPDATE clave=clave;
