<?php
/**
 * Instalador de Bridgi - Sistema de Contabilidad
 * Este archivo crea la base de datos y el usuario administrador inicial
 */

session_start();

// Verificar si ya está instalado
if (file_exists('config.php')) {
    $config = include('config.php');
    if (isset($config['installed']) && $config['installed'] === true) {
        die('<h1>El sistema ya está instalado</h1><p>Si deseas reinstalar, elimina el archivo config.php primero.</p>');
    }
}

$step = $_GET['step'] ?? 1;
$error = '';
$success = '';

// Procesar formulario de configuración de BD
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $step == 1) {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? '';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    
    if (empty($db_name) || empty($db_user)) {
        $error = 'Por favor completa todos los campos requeridos.';
    } else {
        try {
            // Intentar conexión
            $dsn = "mysql:host=$db_host;charset=utf8mb4";
            $pdo = new PDO($dsn, $db_user, $db_pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]);
            
            // Crear base de datos si no existe
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$db_name`");
            
            // Crear tablas
            $sql = file_get_contents('install/schema.sql');
            $pdo->exec($sql);
            
            // Guardar configuración
            $config_content = "<?php\nreturn [\n";
            $config_content .= "    'db_host' => " . var_export($db_host, true) . ",\n";
            $config_content .= "    'db_name' => " . var_export($db_name, true) . ",\n";
            $config_content .= "    'db_user' => " . var_export($db_user, true) . ",\n";
            $config_content .= "    'db_pass' => " . var_export($db_pass, true) . ",\n";
            $config_content .= "    'installed' => false,\n";
            $config_content .= "];\n";
            
            file_put_contents('config.php', $config_content);
            
            header('Location: install.php?step=2');
            exit;
            
        } catch (PDOException $e) {
            $error = 'Error de conexión: ' . $e->getMessage();
        }
    }
}

// Procesar creación de usuario administrador
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $step == 2) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $email = $_POST['email'] ?? '';
    $nombrecompleto = $_POST['nombrecompleto'] ?? '';
    
    if (empty($username) || empty($password) || empty($email) || empty($nombrecompleto)) {
        $error = 'Por favor completa todos los campos.';
    } else {
        try {
            $config = include('config.php');
            $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
            $pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            
            // Crear usuario administrador
            $user_id = uniqid();
            $stmt = $pdo->prepare("INSERT INTO users (id, username, password, nombrecompleto, email, categoria) VALUES (?, ?, ?, ?, ?, 'Administrador')");
            $stmt->execute([$user_id, $username, password_hash($password, PASSWORD_DEFAULT), $nombrecompleto, $email]);
            
            // Marcar como instalado
            $config['installed'] = true;
            $config_content = "<?php\nreturn [\n";
            foreach ($config as $key => $value) {
                $config_content .= "    " . var_export($key, true) . " => " . var_export($value, true) . ",\n";
            }
            $config_content .= "];\n";
            file_put_contents('config.php', $config_content);
            
            // Crear directorio para uploads
            if (!is_dir('uploads')) {
                mkdir('uploads', 0755, true);
            }
            
            $success = true;
            
        } catch (PDOException $e) {
            $error = 'Error al crear usuario: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalación - Bridgi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }
        .install-card { max-width: 600px; margin: 0 auto; }
    </style>
</head>
<body>
    <div class="container">
        <div class="install-card">
            <div class="card shadow-lg">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <img src="app/Images/bridgi.png" alt="Bridgi" style="max-width: 150px;" class="mb-3">
                        <h2>Instalación de Bridgi</h2>
                        <p class="text-muted">El Puente Contable</p>
                    </div>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                    <?php endif; ?>
                    
                    <?php if ($success): ?>
                        <div class="alert alert-success">
                            <h4>¡Instalación completada!</h4>
                            <p>El sistema ha sido instalado correctamente.</p>
                            <p class="mb-0">
                                <a href="app/login.php" class="btn btn-primary">Ir al sistema</a>
                            </p>
                        </div>
                    <?php elseif ($step == 1): ?>
                        <h4 class="mb-4">Paso 1: Configuración de Base de Datos</h4>
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Servidor de Base de Datos</label>
                                <input type="text" name="db_host" class="form-control" value="localhost" required>
                                <small class="text-muted">Generalmente "localhost"</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Nombre de Base de Datos</label>
                                <input type="text" name="db_name" class="form-control" placeholder="bridgi_db" required>
                                <small class="text-muted">Se creará si no existe</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Usuario de Base de Datos</label>
                                <input type="text" name="db_user" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Contraseña de Base de Datos</label>
                                <input type="password" name="db_pass" class="form-control">
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Continuar</button>
                        </form>
                    <?php elseif ($step == 2): ?>
                        <h4 class="mb-4">Paso 2: Usuario Administrador</h4>
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Nombre Completo</label>
                                <input type="text" name="nombrecompleto" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Correo Electrónico</label>
                                <input type="email" name="email" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Nombre de Usuario</label>
                                <input type="text" name="username" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Contraseña</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            <button type="submit" class="btn btn-success w-100">Finalizar Instalación</button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
            <div class="text-center mt-3">
                <small class="text-white">Bridgi © 2025 - Dunamis Group</small>
            </div>
        </div>
    </div>
</body>
</html>
