<?php
/**
 * Manejador de conexión a la base de datos
 */

class Database {
    private static $instance = null;
    private $pdo;
    
    private function __construct() {
        if (!file_exists(__DIR__ . '/config.php')) {
            die('Sistema no instalado. Por favor ejecuta install.php');
        }
        
        $config = include(__DIR__ . '/config.php');
        
        if (!isset($config['installed']) || $config['installed'] !== true) {
            header('Location: install.php');
            exit;
        }
        
        try {
            $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
            $this->pdo = new PDO($dsn, $config['db_user'], $config['db_pass'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]);
        } catch (PDOException $e) {
            error_log("Error de conexión a BD: " . $e->getMessage());
            die('Error de conexión a la base de datos');
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->pdo;
    }
    
    // Prevenir clonación
    private function __clone() {}
    
    // Prevenir deserialización
    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }
}

/**
 * Función helper para obtener la conexión PDO
 */
function getDB() {
    return Database::getInstance()->getConnection();
}
