<?php
session_start();
// Redirigir si no ha iniciado sesión o no es Administrador
if (!isset($_SESSION['username']) || (isset($_SESSION['categoria']) && $_SESSION['categoria'] !== 'Administrador')) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios - Bridgi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center" href="index.html">
                <img src="Images/logoblanco.png" alt="Bridgi Logo" height="30" class="me-2">
                Bridgi
            </a>
            <div class="ms-auto">
                <span class="navbar-text me-3 text-white">Usuario: <?php echo htmlspecialchars($_SESSION['username']); ?></span>
                <a href="../api.php?action=logout" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <main class="container mt-4">
        <div class="card mb-4">
            <div class="card-header"><h4 class="mb-0">Configuración del Sistema</h4></div>
            <div class="card-body">
                <form id="form-settings">
                    <div class="row align-items-end">
                        <div class="col-md-6">
                            <label for="ai-api-key" class="form-label">API Key para Inteligencia Artificial</label>
                            <input type="password" id="ai-api-key" class="form-control form-control-sm" placeholder="Introduce tu clave de API">
                        </div>
                        <div class="col-md-3"><button type="submit" class="btn btn-primary btn-sm">Guardar Configuración</button></div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card">
            <div class="card-header"><h4 class="mb-0">Gestión de Usuarios</h4></div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h5>Usuarios Existentes</h5>
                        <div class="table-responsive">
                            <table class="table table-sm table-hover align-middle">
                                <thead><tr><th>Nombre Completo</th><th>Correo</th><th>Categoría</th><th>Acciones</th></tr></thead>
                                <tbody id="tabla-usuarios"></tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <h5 id="form-user-titulo">Añadir Usuario</h5>
                        <form id="form-nuevo-usuario">
                            <input type="hidden" id="user-id">
                            <div class="mb-2"><label for="user-nombrecompleto" class="form-label">Nombre Completo</label><input type="text" id="user-nombrecompleto" class="form-control form-control-sm" required></div>
                            <div class="mb-2"><label for="user-username" class="form-label">Nombre de Usuario</label><input type="text" id="user-username" class="form-control form-control-sm" required></div>
                            <div class="mb-2"><label for="user-password" class="form-label">Contraseña</label><input type="password" id="user-password" class="form-control form-control-sm" placeholder="Dejar en blanco para no cambiar"></div>
                            <div class="mb-2"><label for="user-documento" class="form-label">Documento</label><input type="text" id="user-documento" class="form-control form-control-sm"></div>
                            <div class="mb-2"><label for="user-email" class="form-label">Correo Electrónico</label><input type="email" id="user-email" class="form-control form-control-sm" required></div>
                            <div class="mb-2"><label for="user-telefono" class="form-label">Teléfono Móvil</label><input type="text" id="user-telefono" class="form-control form-control-sm"></div>
                            <div class="mb-2"><label for="user-direccion" class="form-label">Dirección</label><input type="text" id="user-direccion" class="form-control form-control-sm"></div>
                            <div class="mb-2"><label for="user-ciudad" class="form-label">Ciudad</label><input type="text" id="user-ciudad" class="form-control form-control-sm"></div>
                            <div class="mb-2"><label for="user-pais" class="form-label">País</label><input type="text" id="user-pais" class="form-control form-control-sm"></div>
                            <div class="mb-2"><label for="user-categoria" class="form-label">Categoría</label><select id="user-categoria" class="form-select form-select-sm" required><option value="Administrador">Administrador</option><option value="Contador">Contador</option><option value="Digitador">Digitador</option></select></div>
                            <button type="submit" class="btn btn-success btn-sm">Guardar Usuario</button>
                            <button type="button" id="btn-cancelar-edicion-usuario" class="btn btn-secondary btn-sm d-none">Cancelar</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="container text-center text-muted py-3 mt-4 border-top">
        Bridgi "El Puente Contable". Dunamis Group 2025.
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.getElementById('form-nuevo-usuario').addEventListener('submit', guardarUsuario);
            document.getElementById('form-settings').addEventListener('submit', guardarConfiguracion);
            document.getElementById('btn-cancelar-edicion-usuario').addEventListener('click', cancelarEdicionUsuario);
            cargarUsuarios();
            cargarConfiguracion();
        });

        async function cargarUsuarios() {
            const tablaBody = document.getElementById('tabla-usuarios');
            tablaBody.innerHTML = '<tr><td colspan="3">Cargando...</td></tr>';
            try {
                const response = await fetch('../api.php?action=get_users');
                if (!response.ok) throw new Error('No se pudieron cargar los usuarios.');
                const users = await response.json();

                tablaBody.innerHTML = '';
                users.forEach(user => {
                    const tr = document.createElement('tr');
                    // Pasamos todos los datos del usuario al botón de editar
                    tr.innerHTML = `
                        <td>${user.nombrecompleto || ''}<br><small class="text-muted">${user.username}</small></td>
                        <td>${user.email || ''}</td>
                        <td><span class="badge bg-secondary">${user.categoria || 'N/A'}</span></td>
                        <td>
                            <button class="btn btn-sm btn-warning btn-edit-user" data-user='${JSON.stringify(user)}'>Editar</button>
                            <button class="btn btn-sm btn-danger btn-delete-user" data-id="${user.id}">Eliminar</button>
                        </td>
                    `;
                    tablaBody.appendChild(tr);
                });

                tablaBody.querySelectorAll('.btn-edit-user').forEach(btn => btn.addEventListener('click', (e) => prepararEdicionUsuario(JSON.parse(e.currentTarget.dataset.user))));
                tablaBody.querySelectorAll('.btn-delete-user').forEach(btn => btn.addEventListener('click', (e) => eliminarUsuario(e.target.dataset.id)));

            } catch (error) {
                tablaBody.innerHTML = `<tr><td colspan="3" class="text-danger">${error.message}</td></tr>`;
                console.error('Error al cargar usuarios:', error);
            }
        }

        function prepararEdicionUsuario(user) {
            document.getElementById('form-user-titulo').textContent = 'Editar Usuario';
            document.getElementById('user-id').value = user.id;
            document.getElementById('user-username').value = user.username;
            document.getElementById('user-password').value = '';
            document.getElementById('user-nombrecompleto').value = user.nombrecompleto || '';
            document.getElementById('user-documento').value = user.documento || '';
            document.getElementById('user-email').value = user.email || '';
            document.getElementById('user-telefono').value = user.telefono || '';
            document.getElementById('user-direccion').value = user.direccion || '';
            document.getElementById('user-ciudad').value = user.ciudad || '';
            document.getElementById('user-pais').value = user.pais || '';
            document.getElementById('user-categoria').value = user.categoria || 'Digitador';
            document.getElementById('btn-cancelar-edicion-usuario').classList.remove('d-none');
            document.getElementById('user-password').required = false; // La contraseña es opcional al editar
        }

        function cancelarEdicionUsuario() {
            document.getElementById('form-user-titulo').textContent = 'Añadir Usuario';
            document.getElementById('form-nuevo-usuario').reset();
            document.getElementById('user-id').value = '';
            document.getElementById('btn-cancelar-edicion-usuario').classList.add('d-none');
            document.getElementById('user-password').required = true; // La contraseña es requerida al crear
        }

        async function guardarUsuario(event) {
            event.preventDefault();
            const userId = document.getElementById('user-id').value;
            const username = document.getElementById('user-username').value;
            const password = document.getElementById('user-password').value;
            const nombrecompleto = document.getElementById('user-nombrecompleto').value;
            const documento = document.getElementById('user-documento').value;
            const email = document.getElementById('user-email').value;
            const telefono = document.getElementById('user-telefono').value;
            const direccion = document.getElementById('user-direccion').value;
            const ciudad = document.getElementById('user-ciudad').value;
            const pais = document.getElementById('user-pais').value;
            const categoria = document.getElementById('user-categoria').value;

            const action = userId ? 'update_user' : 'create_user';
            const data = { 
                id: userId, username, password, nombrecompleto, documento, email, 
                telefono, direccion, ciudad, pais, categoria 
            };

            try {
                const response = await fetch(`../api.php?action=${action}`, { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(data) });
                const result = await response.json();
                if (!response.ok) throw new Error(result.error || 'Error al guardar el usuario.');
                cancelarEdicionUsuario();
                cargarUsuarios();
            } catch (error) {
                alert(error.message);
            }
        }

        async function eliminarUsuario(userId) {
            if (confirm('¿Está seguro de que desea eliminar este usuario?')) {
                try {
                    const response = await fetch('../api.php?action=delete_user', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id: userId }) });
                    const result = await response.json();
                    if (!response.ok) throw new Error(result.error || 'Error al eliminar el usuario.');
                    cargarUsuarios();
                } catch (error) {
                    alert(error.message);
                }
            }
        }

        async function cargarConfiguracion() {
            try {
                const response = await fetch('../api.php?action=get_settings');
                if (!response.ok) throw new Error('No se pudo cargar la configuración.');
                const settings = await response.json();
                document.getElementById('ai-api-key').value = settings.ai_api_key || '';
            } catch (error) {
                console.error('Error al cargar configuración:', error);
                alert(error.message);
            }
        }

        async function guardarConfiguracion(event) {
            event.preventDefault();
            const apiKey = document.getElementById('ai-api-key').value;
            try {
                const response = await fetch('../api.php?action=save_settings', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ ai_api_key: apiKey }) });
                const result = await response.json();
                if (!response.ok) throw new Error(result.error || 'Error al guardar la configuración.');
                alert('Configuración guardada con éxito.');
            } catch (error) {
                alert(error.message);
            }
        }
    </script>
</body>
</html>