# Bridgi - El Puente Contable

Sistema de contabilidad basado en web con MySQL.
**Dunamis Group © 2025**

## Requisitos del Servidor

- PHP 8.0 o superior
- MySQL 5.7 o superior
- Apache con mod_rewrite habilitado
- Extensiones PHP requeridas:
  - PDO
  - PDO_MySQL
  - mysqli
  - curl
  - json
  - fileinfo

## Instalación

### 1. Subir archivos al servidor

Sube todos los archivos del ZIP a tu servidor web (generalmente en `public_html` o `www`).

### 2. Configurar permisos

Asegúrate de que las siguientes carpetas tengan permisos de escritura (755 o 777):
```bash
chmod 755 uploads/
chmod 755 install/
```

### 3. Crear base de datos

Crea una nueva base de datos MySQL desde tu panel de control (cPanel, Plesk, etc.) o mediante phpMyAdmin:
```sql
CREATE DATABASE bridgi_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

También necesitarás un usuario de base de datos con todos los privilegios sobre esa base de datos.

### 4. Ejecutar instalador

Abre tu navegador y ve a:
```
http://tudominio.com/install.php
```

Sigue los pasos del instalador:

**Paso 1: Configuración de Base de Datos**
- Servidor: `localhost` (generalmente)
- Nombre de BD: El nombre que creaste
- Usuario: Tu usuario MySQL
- Contraseña: La contraseña de tu usuario MySQL

**Paso 2: Usuario Administrador**
- Crea tu primer usuario administrador
- Este usuario tendrá acceso completo al sistema

### 5. ¡Listo!

Una vez completada la instalación, serás redirigido al login del sistema.

## Características

- ✅ Gestión de múltiples empresas
- ✅ Plan de cuentas personalizable
- ✅ Libro diario
- ✅ Balance de comprobación
- ✅ Estado de resultados
- ✅ Balance general
- ✅ Liquidación de IVA
- ✅ Calendario de vencimientos
- ✅ Exportación a CSV/Excel
- ✅ Múltiples usuarios con roles
- ✅ Registro de actividad
- ✅ Análisis con IA (OpenAI/Gemini)

## Roles de Usuario

- **Administrador**: Acceso completo, gestión de usuarios y sistema
- **Contador**: Gestión de empresas, reportes y análisis
- **Digitador**: Carga de asientos contables

## Soporte Técnico

Para soporte o consultas:
- Email: soporte@dunamis.com.py
- Web: https://dunamis.com.py

## Seguridad

### Recomendaciones post-instalación:

1. **Eliminar el instalador**: Una vez instalado, elimina o renombra `install.php`
   ```bash
   rm install.php
   # o
   mv install.php install.php.bak
   ```

2. **Proteger config.php**: Ya está protegido por .htaccess, pero verifica que no sea accesible desde el navegador

3. **HTTPS**: Usa siempre HTTPS en producción. Instala un certificado SSL (Let's Encrypt es gratuito)

4. **Backups**: Configura backups automáticos de tu base de datos

5. **Actualizaciones**: Mantén PHP y MySQL actualizados

## Solución de Problemas

### Error de conexión a BD
- Verifica que los datos en `config.php` sean correctos
- Asegúrate de que MySQL esté corriendo
- Verifica que el usuario tenga los permisos necesarios

### Página en blanco
- Activa display_errors en PHP temporalmente para ver el error
- Revisa los logs de Apache/PHP
- Verifica permisos de archivos

### Error 500
- Revisa el archivo .htaccess
- Verifica que mod_rewrite esté habilitado
- Revisa los logs del servidor

### No puedo subir logos
- Verifica permisos de la carpeta `uploads/`
- Revisa el límite de tamaño de archivo en php.ini (`upload_max_filesize`)

## Actualizaciones

Para actualizar el sistema:
1. Haz backup de tu base de datos
2. Haz backup de tu carpeta `uploads/`
3. Haz backup de `config.php`
4. Sube los nuevos archivos
5. Restaura `config.php` y la carpeta `uploads/`

## Licencia

Propietario - Dunamis Group 2025
Todos los derechos reservados.

## Créditos

Desarrollado por Dunamis Group
- Sistema de contabilidad para empresas paraguayas
- Cumple con normativas fiscales de Paraguay
