<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 1. Recoger los datos del formulario
    // Se usa 'isset' para evitar errores si un campo no llega.
    $nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : 'No especificado';
    $email = isset($_POST['email']) ? trim($_POST['email']) : 'No especificado';
    $mensaje = isset($_POST['mensaje']) ? trim($_POST['mensaje']) : 'No especificado';

    // 2. Validar que los campos requeridos no estén vacíos
    if (empty($nombre) || empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Si hay un error, redirige de vuelta al formulario.
        header("Location: index.html#contacto");
        exit;
    }

    // 3. Configurar los detalles del correo electrónico
    $destinatario = "info@cprconsultora.com";
    $asunto = "Nueva Solicitud de Contacto desde Arras BPO";
    
    // 4. Construir el cuerpo del mensaje
    $cuerpoMensaje = "Has recibido una nueva solicitud de contacto:\n\n";
    $cuerpoMensaje .= "Nombre: " . $nombre . "\n";
    $cuerpoMensaje .= "Correo electrónico: " . $email . "\n";
    $cuerpoMensaje .= "Mensaje:\n" . $mensaje . "\n";

    // 5. Configurar las cabeceras del correo para que el 'From' sea el correo del usuario
    $headers = "From: " . $nombre . " <" . $email . ">";

    // 6. Enviar el correo y redirigir al usuario a la página principal
    mail($destinatario, $asunto, $cuerpoMensaje, $headers);
    header("Location: index.html#contacto");
    exit;
}
?>