# 📦 INSTRUCCIONES DE INSTALACIÓN - LexiPro v1.0.0

## 🎯 Sistema de Gestión Jurídica Completo

---

## 📋 REQUISITOS DEL SERVIDOR

### Requisitos Mínimos
- **PHP**: 7.4 o superior
- **MySQL**: 5.7 o superior (o MariaDB 10.3+)
- **Servidor Web**: Apache 2.4+ con mod_rewrite habilitado
- **Espacio en disco**: 500 MB mínimo
- **Memoria PHP**: 128 MB mínimo (recomendado 256 MB)

### Extensiones PHP Requeridas
- ✅ PDO
- ✅ PDO MySQL
- ✅ MBString
- ✅ GD (para procesamiento de imágenes)
- ✅ JSON
- ✅ OpenSSL (recomendado)

---

## 🚀 INSTALACIÓN EN HOSTING WEB

### Paso 1: Subir Archivos

1. **Descomprimir el archivo ZIP**
   - Extrae `lexipro.zip` en tu computadora

2. **Conectar por FTP/SFTP**
   - Usa un cliente FTP como FileZilla o WinSCP
   - Conecta a tu servidor con las credenciales proporcionadas por tu hosting

3. **Subir archivos**
   - Sube **todos los archivos** del ZIP a la carpeta `public_html` o `www` de tu hosting
   - Asegúrate de mantener la estructura de carpetas intacta
   - **Importante**: Sube también los archivos ocultos como `.htaccess`

### Paso 2: Configurar Permisos

Asigna permisos de **escritura (755)** a las siguientes carpetas:
```
/uploads (y todas sus subcarpetas)
/config
/install (temporal)
```

En cPanel esto se hace:
1. Selecciona la carpeta
2. Clic derecho → "Permisos de Archivo"
3. Marca: Read, Write, Execute para Owner
4. Clic en "Cambiar Permisos"

### Paso 3: Crear Base de Datos

1. **Accede a cPanel → MySQL Databases**
2. **Crear nueva base de datos**:
   - Nombre: `lexipro` (o el que prefieras)
   - Charset: `utf8mb4`
   - Collation: `utf8mb4_unicode_ci`

3. **Crear usuario de base de datos**:
   - Usuario: `lexipro_user`
   - Contraseña: (genera una segura)
   
4. **Asignar permisos**:
   - Asocia el usuario a la base de datos
   - Otorga **TODOS LOS PRIVILEGIOS**

5. **Anota estos datos** (los necesitarás en el instalador):
   - Servidor: `localhost` (normalmente)
   - Base de datos: `lexipro`
   - Usuario: `lexipro_user`
   - Contraseña: la que generaste

### Paso 4: Ejecutar el Instalador Web

1. **Accede al instalador**:
   ```
   http://tudominio.com/install/
   ```

2. **Sigue los 6 pasos del instalador**:

   **PASO 1: Verificación de Requisitos**
   - El sistema verificará que tu servidor cumple todos los requisitos
   - Si algo falla en rojo, contacta a tu proveedor de hosting
   - Clic en "Continuar"

   **PASO 2: Configuración de Base de Datos**
   - Servidor: `localhost`
   - Nombre de la BD: `lexipro`
   - Usuario: `lexipro_user`
   - Contraseña: tu contraseña de BD
   - Clic en "Continuar"

   **PASO 3: Crear Tablas**
   - Si la conexión fue exitosa, verás un mensaje de confirmación
   - Clic en "Crear Tablas"
   - El sistema creará automáticamente todas las tablas necesarias

   **PASO 4: Crear Usuario Administrador**
   - Nombre: Tu nombre
   - Apellido: Tu apellido
   - Usuario: `admin` (o el que prefieras)
   - Email: tu email
   - Contraseña: (elige una segura, mínimo 6 caracteres)
   - **IMPORTANTE**: Anota bien estos datos
   - Clic en "Continuar"

   **PASO 5: Datos de la Empresa**
   - Nombre de la Empresa: Nombre de tu estudio jurídico
   - RUC: Tu RUC (opcional)
   - Dirección, teléfono, email: datos de contacto
   - Ciudad: Asunción (o tu ciudad)
   - País: Paraguay
   - URL de la Aplicación: (se auto-completa)
   - Clic en "Finalizar Instalación"

   **PASO 6: ¡Instalación Completada!**
   - Verás tus credenciales de acceso
   - **Anota bien el usuario y contraseña**
   - Clic en "Ir al Panel de Login"

### Paso 5: Seguridad Post-Instalación

**🔒 MUY IMPORTANTE - SEGURIDAD:**

1. **Eliminar carpeta de instalación**:
   - Ve por FTP a la carpeta raíz
   - **ELIMINA** la carpeta `/install/`
   - O renómbrala a `/install_backup/`

2. **Verificar permisos del archivo de configuración**:
   - El archivo `/config/config.php` debe tener permisos `644`

3. **Configurar .htaccess** (ya incluido):
   - Protege archivos SQL
   - Previene listado de directorios
   - Protección contra inyección de código

---

## 🖥️ INSTALACIÓN EN LOCALHOST (XAMPP)

### Paso 1: Instalar XAMPP
- Descarga XAMPP desde: https://www.apachefriends.org
- Instala en `C:\xampp`

### Paso 2: Copiar Archivos
- Extrae el ZIP en `C:\xampp\htdocs\lexipro`

### Paso 3: Crear Base de Datos
1. Inicia XAMPP Control Panel
2. Inicia Apache y MySQL
3. Abre phpMyAdmin: `http://localhost/phpmyadmin`
4. Clic en "Nueva" → Nombre: `lexipro`

### Paso 4: Ejecutar Instalador
- Abre: `http://localhost/lexipro/install/`
- Sigue los pasos del instalador
- Usuario de BD: `root`
- Contraseña de BD: (vacío)

### Paso 5: Acceder al Sistema
- URL: `http://localhost/lexipro/login.php`
- Usuario: el que creaste en el instalador
- Contraseña: la que definiste

---

## 🔧 CONFIGURACIÓN ADICIONAL

### Configurar PHP (opcional pero recomendado)

Edita el archivo `php.ini` (en cPanel: "Editor PHP"):

```ini
upload_max_filesize = 50M
post_max_size = 50M
max_execution_time = 300
memory_limit = 256M
```

### Configurar Correo Electrónico (opcional)

Para enviar notificaciones por email, configura SMTP en `config/config.php`:

```php
// Configuración de email
define('MAIL_FROM', 'noreply@tudominio.com');
define('MAIL_FROM_NAME', 'LexiPro');
define('MAIL_HOST', 'smtp.tudominio.com');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', 'tu_usuario_smtp');
define('MAIL_PASSWORD', 'tu_password_smtp');
define('MAIL_ENCRYPTION', 'tls');
```

---

## 🆘 SOLUCIÓN DE PROBLEMAS

### Error: "Base de datos no encontrada"
- Verifica que hayas creado la base de datos en MySQL
- Verifica las credenciales en el paso 2 del instalador

### Error: "No se puede escribir en config"
- Asigna permisos 755 a la carpeta `/config`
- En algunos hostings necesitas 777 (temporal, cambia a 644 después)

### Error 500 - Internal Server Error
- Verifica que `.htaccess` se haya subido correctamente
- Verifica que mod_rewrite esté habilitado
- Revisa el log de errores de Apache (en cPanel: Error Log)

### No se pueden subir archivos
- Verifica permisos de la carpeta `/uploads` (debe ser 755)
- Verifica configuración PHP: `upload_max_filesize`

### Página en blanco después del login
- Activa el modo debug en `config/config.php`:
  ```php
  define('DEBUG_MODE', true);
  ```
- Verifica errores de PHP en el log

### No aparecen los estilos CSS
- Limpia la caché del navegador (Ctrl + Shift + Del)
- Verifica que la carpeta `/assets` se haya subido completa

---

## 📞 SOPORTE Y DOCUMENTACIÓN

### Documentación Completa
- Ver archivo: `README.md`
- Manual de usuario: `/docs/manual-usuario.pdf` (próximamente)

### Contacto para Soporte
- Email: soporte@lexipro.com
- Web: https://lexipro.com/soporte

### Recursos Adicionales
- Tutoriales en video: YouTube - Canal LexiPro
- Base de conocimientos: https://docs.lexipro.com
- Foro de la comunidad: https://forum.lexipro.com

---

## ✅ CHECKLIST DE INSTALACIÓN

Marca cada paso conforme lo completes:

- [ ] Requisitos del servidor verificados
- [ ] Archivos subidos al servidor
- [ ] Permisos de carpetas configurados
- [ ] Base de datos creada
- [ ] Usuario de base de datos creado y asignado
- [ ] Instalador web ejecutado (6 pasos completados)
- [ ] Credenciales de administrador anotadas
- [ ] Carpeta /install eliminada o renombrada
- [ ] Primer login exitoso
- [ ] Sistema funcionando correctamente

---

## 🎉 ¡INSTALACIÓN COMPLETADA!

Tu sistema LexiPro está listo para usar. Accede con:

```
URL: http://tudominio.com/login.php
Usuario: [el que creaste]
Contraseña: [la que definiste]
```

### Próximos Pasos Recomendados:

1. **Personalizar la empresa**:
   - Ir a Configuración → Datos de la Empresa
   - Subir logo
   - Completar información de facturación

2. **Crear usuarios**:
   - Ir a Usuarios → Nuevo Usuario
   - Asignar roles y permisos

3. **Configurar módulos**:
   - Ir a Configuración → Módulos
   - Activar/desactivar según necesites

4. **Crear tu primer caso**:
   - Ir a Casos → Nuevo Caso
   - Completar información

---

**Desarrollado con ❤️ para abogados y estudios jurídicos en Paraguay**

© 2025 LexiPro - Todos los derechos reservados
Versión 1.0.0