<?php
// Este es un sistema de seguimiento muy básico.
// Para análisis avanzados, se recomienda usar Google Analytics.

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    exit;
}

$page = isset($_POST['page']) ? $_POST['page'] : 'unknown';

$visit = [
    'page' => $page,
    'timestamp' => date('Y-m-d H:i:s')
];

$visits_file = 'visits.json';
$visits = [];

if (file_exists($visits_file)) {
    $json_content = file_get_contents($visits_file);
    $visits = json_decode($json_content, true) ?: [];
}

array_unshift($visits, $visit);

// Para evitar que el archivo crezca indefinidamente, podemos limitarlo a, por ejemplo, las últimas 5000 visitas.
$visits = array_slice($visits, 0, 5000);

file_put_contents($visits_file, json_encode($visits, JSON_PRETTY_PRINT));

http_response_code(204); // No Content
?>