<?php
header('Content-Type: application/json');

function send_json_response($success, $message) {
    echo json_encode(['success' => $success, 'message' => $message]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_json_response(false, 'Método no permitido.');
}

$config_file = 'config.json';

// Cargar configuración existente
$config = [];
if (file_exists($config_file)) {
    $config = json_decode(file_get_contents($config_file), true);
}

// Actualizar con los nuevos datos del POST
$config['google_analytics_key'] = isset($_POST['google_analytics_key']) ? trim($_POST['google_analytics_key']) : ($config['google_analytics_key'] ?? '');
$config['recaptcha_site_key'] = isset($_POST['recaptcha_site_key']) ? trim($_POST['recaptcha_site_key']) : ($config['recaptcha_site_key'] ?? '');
$config['recaptcha_secret_key'] = isset($_POST['recaptcha_secret_key']) ? trim($_POST['recaptcha_secret_key']) : ($config['recaptcha_secret_key'] ?? '');


// Guardar la configuración actualizada
if (file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    send_json_response(true, 'Configuración guardada correctamente.');
} else {
    send_json_response(false, 'Error al guardar el archivo de configuración.');
}

?>