<?php
session_start();

// Si el usuario no ha iniciado sesión, redirigirlo a la página de login.
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.html");
    exit;
}
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Administración - Contactos DIFSA</title>
    <!-- Icono de la página (Favicon) -->
    <link rel="icon" type="image/png" href="images/iso.png">
    <!-- Carga de Tailwind CSS -->
    <link href="output.css" rel="stylesheet">
    <!-- Carga de Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <style>
        :root {
            --color-primary: #05331d;
            --color-secondary: #b07825;
            --color-light-green: #21472e;
            --color-accent: #784004;
        }
        body { font-family: 'Inter', sans-serif; }
        .bg-primary { background-color: var(--color-primary); }
        .text-primary { color: var(--color-primary); }
        .bg-secondary { background-color: var(--color-secondary); }
        .text-secondary { color: var(--color-secondary); }
        .hover\:bg-accent:hover { background-color: var(--color-accent); }
        .border-light-green { border-color: var(--color-light-green); }

        /* Estilo para enlaces del menú lateral */
        .sidebar-link {
            display: flex; align-items: center; padding: 0.75rem 1.5rem;
            color: #d1d5db; transition: background-color 0.2s, color 0.2s;
            border-left: 4px solid transparent;
        }
        .sidebar-link:hover { background-color: var(--color-light-green); color: white; }
        .sidebar-link.active {
            background-color: var(--color-light-green); color: white;
            font-weight: 600; border-left-color: var(--color-secondary);
        }
    </style>
</head>
<body class="bg-gray-100">

    <div class="flex h-screen">
        <!-- Sidebar -->
        <aside class="w-64 bg-primary text-white flex flex-col">
            <div class="h-20 flex items-center justify-center border-b border-light-green">
                <img src="images/difsacompleto.png" alt="Logo DIFSA" class="h-10">
            </div>
            <nav class="flex-1 mt-4">
                <a href="#dashboard" class="sidebar-link active" onclick="showPage('dashboard')"><i class="fas fa-tachometer-alt w-6 mr-2"></i> Dashboard</a>
                <a href="#contactos" class="sidebar-link" onclick="showPage('contactos')"><i class="fas fa-envelope-open-text w-6 mr-2"></i> Contactos</a>
                <a href="#blog" class="sidebar-link" onclick="showPage('blog')"><i class="fas fa-newspaper w-6 mr-2"></i> Blog / Recursos</a>
                <a href="#descargas" class="sidebar-link" onclick="showPage('descargas')"><i class="fas fa-download w-6 mr-2"></i> Descargas</a>
                <a href="#usuarios" class="sidebar-link" onclick="showPage('usuarios')"><i class="fas fa-users-cog w-6 mr-2"></i> Usuarios</a>
                <a href="#configuracion" class="sidebar-link" onclick="showPage('configuracion')"><i class="fas fa-cogs w-6 mr-2"></i> Configuración</a>
            </nav>
            <div class="p-4 border-t border-light-green space-y-3 mt-auto">
                <a href="logout.php" class="flex items-center text-sm text-red-400 hover:text-red-200 transition-colors"><i class="fas fa-sign-out-alt w-6 mr-2"></i>Cerrar Sesión</a>
                <a href="index.html" class="flex items-center text-sm text-gray-300 hover:text-white transition-colors"><i class="fas fa-home w-6 mr-2"></i>Volver al Sitio</a>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <header class="bg-white shadow-sm p-4">
                <h1 id="page-title" class="text-2xl font-bold text-primary">Dashboard</h1>
            </header>

            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 p-4 sm:p-6 lg:p-8">
                
                <!-- === PÁGINA: DASHBOARD === -->
                <section id="page-dashboard" class="page-content">
                    <h2 class="text-xl font-semibold text-gray-800 mb-4">Resumen General</h2>
                    <p>Bienvenido al panel de control de DIFSA. Aquí podrás gestionar todo el contenido y la información de tu sitio web.</p>
                </section>

                <!-- === PÁGINA: CONTACTOS === -->
                <section id="page-contactos" class="page-content hidden">
                    <div class="bg-white shadow-md rounded-lg overflow-hidden">
                        <div class="px-6 py-4 border-b">
                            <h2 class="text-xl font-semibold text-gray-800">Consultas Recibidas</h2>
                            <p class="text-gray-600 text-sm mt-1">Mensajes enviados desde el formulario de contacto.</p>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nombre</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Servicios de Interés</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Mensaje</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <?php
                                    $file_path = 'contacts.csv';
                                    if (file_exists($file_path)) {
                                        // Abrir el archivo en modo lectura
                                        $lines = file($file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                                        if ($lines !== false) {
                                            // Invertir el array para mostrar los más recientes primero
                                            $reversed_lines = array_reverse($lines);

                                            // Iterar sobre las líneas en orden inverso
                                            foreach ($reversed_lines as $line) {
                                                // Separar los datos por el delimitador
                                                $data = explode(';', trim($line));

                                                // Asegurarse de que hay 5 columnas de datos
                                                if (count($data) == 5) {
                                                    list($date, $name, $email, $services, $message) = $data;
                                                    // Escapar los datos para prevenir problemas de visualización con caracteres especiales (XSS)
                                                    echo "<tr>";
                                                    echo "<td class='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>" . htmlspecialchars($date) . "</td>";
                                                    echo "<td class='px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900'>" . htmlspecialchars($name) . "</td>";
                                                    echo "<td class='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>" . htmlspecialchars($email) . "</td>";
                                                    echo "<td class='px-6 py-4 text-sm text-gray-500'>" . htmlspecialchars($services) . "</td>";
                                                    echo "<td class='px-6 py-4 text-sm text-gray-500 max-w-sm truncate' title='" . htmlspecialchars($message) . "'>" . htmlspecialchars($message) . "</td>";
                                                    echo "</tr>";
                                                }
                                            }
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

                <!-- === PÁGINA: BLOG / RECURSOS === -->
                <section id="page-blog" class="page-content hidden">
                    <div class="bg-white shadow-md rounded-lg p-6">
                        <h2 class="text-xl font-semibold text-gray-800 mb-4">Crear Nuevo Artículo</h2>
                        <form class="space-y-4">
                            <div>
                                <label for="blog-title" class="block text-sm font-medium text-gray-700">Título del Artículo</label>
                                <input type="text" id="blog-title" name="blog-title" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm p-2 border">
                            </div>
                            <div>
                                <label for="blog-category" class="block text-sm font-medium text-gray-700">Categoría</label>
                                <input type="text" id="blog-category" name="blog-category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm p-2 border" placeholder="Ej: TRIBUTACIÓN, AGRO">
                            </div>
                            <div>
                                <label for="blog-content" class="block text-sm font-medium text-gray-700">Contenido</label>
                                <textarea id="blog-content" name="blog-content" rows="10" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm p-2 border"></textarea>
                            </div>
                            <button type="submit" class="px-4 py-2 bg-secondary text-white rounded-md hover:bg-accent">Publicar Artículo</button>
                        </form>
                    </div>
                </section>

                <!-- === PÁGINA: DESCARGAS === -->
                <section id="page-descargas" class="page-content hidden">
                     <div class="bg-white shadow-md rounded-lg overflow-hidden">
                        <div class="px-6 py-4 border-b">
                            <h2 class="text-xl font-semibold text-gray-800">Registro de Descargas</h2>
                            <p class="text-gray-600 text-sm mt-1">Usuarios que han descargado recursos desde el blog.</p>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email del Usuario</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Recurso Descargado</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <!-- Filas de ejemplo -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

                <!-- === PÁGINA: USUARIOS === -->
                <section id="page-usuarios" class="page-content hidden">
                    <div class="bg-white shadow-md rounded-lg overflow-hidden">
                        <div class="px-6 py-4 border-b flex justify-between items-center">
                            <div>
                                <h2 class="text-xl font-semibold text-gray-800">Gestión de Usuarios</h2>
                                <p class="text-gray-600 text-sm mt-1">Administradores del panel de control.</p>
                            </div>
                            <button class="px-4 py-2 bg-secondary text-white rounded-md hover:bg-accent">Añadir Usuario</button>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nombre de Usuario</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Rol</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">admin</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Super Admin</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><a href="#" class="text-indigo-600 hover:text-indigo-900">Editar</a></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

                <!-- === PÁGINA: CONFIGURACIÓN === -->
                <section id="page-configuracion" class="page-content hidden">
                    <div class="bg-white shadow-md rounded-lg p-6">
                        <h2 class="text-xl font-semibold text-gray-800 mb-4">Parametrización del Sitio</h2>
                        <form class="space-y-6">
                            <div>
                                <label for="ga-key" class="block text-sm font-medium text-gray-700">Google Analytics Key</label>
                                <input type="text" id="ga-key" name="ga-key" class="mt-1 block w-full md:w-1/2 rounded-md border-gray-300 shadow-sm p-2 border" placeholder="UA-XXXXX-Y">
                            </div>
                            <div>
                                <label for="recaptcha-key" class="block text-sm font-medium text-gray-700">Google reCAPTCHA v3 Site Key</label>
                                <input type="text" id="recaptcha-key" name="recaptcha-key" class="mt-1 block w-full md:w-1/2 rounded-md border-gray-300 shadow-sm p-2 border">
                            </div>
                            <button type="submit" class="px-4 py-2 bg-secondary text-white rounded-md hover:bg-accent">Guardar Cambios</button>
                        </form>
                    </div>
                </section>

            </main>
        </div>
    </div>

    <script>
        const pageTitle = document.getElementById('page-title');

        function showPage(pageId) {
            // Ocultar todas las páginas
            document.querySelectorAll('.page-content').forEach(page => {
                page.classList.add('hidden');
            });

            // Mostrar la página seleccionada
            const activePage = document.getElementById('page-' + pageId);
            if (activePage) {
                activePage.classList.remove('hidden');
            }

            // Actualizar el título principal
            const activeLink = document.querySelector(`.sidebar-link[href="#${pageId}"]`);
            if (activeLink) {
                pageTitle.textContent = activeLink.textContent;
            }

            // Actualizar la clase 'active' en el menú
            document.querySelectorAll('.sidebar-link').forEach(link => {
                link.classList.remove('active');
            });
            if(activeLink) {
                activeLink.classList.add('active');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            // Mostrar la página inicial (dashboard)
            showPage('dashboard');

            // Manejar la navegación con hash
            window.onhashchange = () => {
                const hash = window.location.hash.substring(1);
                if (hash) {
                    showPage(hash);
                }
            };
            // Cargar página desde hash si existe
            if (window.location.hash) {
                showPage(window.location.hash.substring(1));
            }
        });
    </script>
</body>
</html>