<?php
header('Content-Type: application/json');

function send_json_response($success, $message) {
    echo json_encode(['success' => $success, 'message' => $message]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_json_response(false, 'Método no permitido.');
}

$index = isset($_POST['index']) ? (int)$_POST['index'] : -1;

if ($index < 0) {
    send_json_response(false, 'Índice de registro no válido.');
}

$file_path = 'downloads.json';

if (!file_exists($file_path)) {
    send_json_response(false, 'El archivo de registros de descargas no existe.');
}

$json_content = file_get_contents($file_path);
$downloads = json_decode($json_content, true);

if (!is_array($downloads) || !isset($downloads[$index])) {
    send_json_response(false, 'El registro a eliminar no fue encontrado o el archivo está corrupto.');
}

// Eliminar el elemento del array
array_splice($downloads, $index, 1);

// Guardar el array actualizado en el archivo JSON
if (file_put_contents($file_path, json_encode($downloads, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    send_json_response(true, 'Registro de descarga eliminado correctamente.');
} else {
    send_json_response(false, 'Error al guardar los cambios en el archivo JSON.');
}
?>