document.addEventListener('DOMContentLoaded', () => {
    const PROFESIONALES_API_URL = 'api.php?entity=profesionales';
    const PACIENTES_API_URL = 'api.php?entity=pacientes';
    const CONFIG_API_URL = 'api.php?entity=configuracion';

    const profesionalSelect = document.getElementById('profesional-report-select');
    const pacienteSelect = document.getElementById('paciente-report-select');

    const loadInitialData = async () => {
        try {
            const [profesionalesRes, pacientesRes, configRes] = await Promise.all([
                fetch(PROFESIONALES_API_URL),
                fetch(PACIENTES_API_URL),
                fetch(CONFIG_API_URL)
            ]);

            const profesionales = await profesionalesRes.json();
            const pacientes = await pacientesRes.json();
            const config = await configRes.json();

            // Cargar info de la clínica en el header
            document.getElementById('clinic-name').textContent = config.clinica_nombre || 'Clinic App';
            if (config.clinica_logo) {
                document.getElementById('clinic-logo').src = config.clinica_logo;
            }

            // Poblar el dropdown de profesionales
            profesionales.forEach(prof => {
                profesionalSelect.innerHTML += `<option value="${prof.id}">${prof.nombre} ${prof.apellido}</option>`;
            });

            // Poblar el dropdown de pacientes
            pacientes.forEach(pac => {
                pacienteSelect.innerHTML += `<option value="${pac.id}">${pac.nombre} ${pac.apellido}</option>`;
            });

        } catch (error) {
            console.error("Error al cargar los datos iniciales:", error);
        }
    };

    loadInitialData();
});