<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>

    <div class="container">
        <div class="controls">
            <input type="text" id="search-input" placeholder="Buscar por nombre o apellido...">
            <button id="open-modal-btn">Nuevo Profesional</button>
        </div>

        <h2>Profesionales Registrados</h2>
        <table id="profesionales-table">
            <thead>
                <tr>
                <th>Foto</th>
                <th data-sort="nombre">Nombre</th>
                <th data-sort="apellido">Apellido</th>
                <th>Especialidad</th>
                <th>Email</th>
                <th>Teléfono</th>
                <th>Estado</th>
                <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="profesionales-table-body">
                <!-- Rows will be inserted here by JavaScript -->
            </tbody>
        </table>

        <!-- The Modal -->
        <div id="profesional-modal" class="modal">
            <!-- Modal content -->
            <div class="modal-content">
            <span class="close-btn">&times;</span>
            <h2>Registrar Nuevo Profesional</h2>
            <form id="profesional-form">
                <input type="hidden" id="profesional-id">
                <img id="foto-preview" src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23bdc3c7'%3E%3Cpath d='M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z'/%3E%3C/svg%3E" alt="Vista previa de la foto" style="max-width: 100px; max-height: 100px; display: block; margin-bottom: 10px;">
                <label for="foto">URL de la Foto de Perfil:</label>
                <div class="input-with-button">
                    <input type="text" id="foto" name="foto" placeholder="https://ejemplo.com/imagen.jpg">
                    <button type="button" id="clear-foto-btn" class="clear-btn">Borrar</button>
                </div>                
                <div class="form-grid">
                    <input type="text" id="nombre" name="nombre" placeholder="Nombre" required>
                    <input type="text" id="apellido" name="apellido" placeholder="Apellido" required>
                    <input type="text" id="matricula" name="matricula" placeholder="Nro. de Matrícula Profesional">
                    <input type="text" id="especialidad" name="especialidad" placeholder="Especialidad" required>
                </div>
                <input type="email" id="email" name="email" placeholder="Email" required>
                <input type="tel" id="telefono" name="telefono">
                <input type="password" id="password" name="password" placeholder="Contraseña (dejar en blanco para no cambiar)">
                <textarea id="biografia" name="biografia" placeholder="Biografía o resumen profesional..."></textarea>
                <label for="status">Estado:</label>
                <select id="status" name="status">
                    <option value="activo">Activo</option>
                    <option value="inactivo">Inactivo</option>
                </select>
                <label for="role">Rol de Usuario:</label>
                <select id="role" name="role">
                    <option value="profesional">Profesional</option>
                    <option value="secretario">Secretario/a</option>
                    <option value="admin">Administrador</option>
                </select>
                <button type="submit">Guardar Profesional</button>
            </form>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>