document.addEventListener('DOMContentLoaded', () => {
    const loginForm = document.getElementById('login-form');
    const errorMessage = document.getElementById('error-message');

    // Cargar datos de la clínica para mostrar en el login
    const loadClinicInfo = async () => {
        try {
            const response = await fetch('api.php?entity=configuracion');
            const config = await response.json();
            document.getElementById('clinic-name-login').textContent = config.clinica_nombre || 'ClinicApp';
            if (config.clinica_logo) {
                document.getElementById('clinic-logo-login').src = config.clinica_logo;
            } else {
                document.getElementById('clinic-logo-login').remove(); // Ocultamos el logo si no existe
            }
        } catch (error) {
            console.error("No se pudo cargar la info de la clínica", error);
            document.getElementById('clinic-name-login').textContent = 'ClinicApp';
            document.getElementById('clinic-logo-login').remove();
        }
    };

    loginForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        errorMessage.style.display = 'none';

        const email = document.getElementById('email').value;
        const password = document.getElementById('password').value;

        try {
            const response = await fetch('auth.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ email, password })
            });

            if (response.ok) {
                // Si el login es exitoso, redirigir al dashboard (que ahora es index.php)
                window.location.href = 'index.php';
            } else {
                const result = await response.json();
                errorMessage.textContent = result.message;
                errorMessage.style.display = 'block';
            }
        } catch (error) {
            errorMessage.textContent = 'Error de conexión. Inténtalo de nuevo.';
            errorMessage.style.display = 'block';
        }
    });

    loadClinicInfo();
});