<?php
// Activar la visualización de errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

$config_file = 'config_db.php';
$error_message = '';
$success_message = '';
$install_completed = false;

// 1. VERIFICAR SI LA INSTALACIÓN YA SE REALIZÓ
if (file_exists($config_file)) {
    include_once $config_file;
    // Comprobar si las constantes de la DB están definidas y no son los valores por defecto
    if (defined('DB_HOST') && DB_NAME !== 'nombre_de_tu_base_de_datos') {
        // Intentar conectar para verificar si la DB y las tablas existen
        $conn_check = @new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if (!$conn_check->connect_error) {
            // Comprobar si ya existe un usuario administrador
            $admin_check_result = $conn_check->query("SELECT id FROM usuarios WHERE role = 'admin' LIMIT 1");
            if ($admin_check_result && $admin_check_result->num_rows > 0) {
                $install_completed = true; // La instalación está completa
            }
            $conn_check->close();
        }
    }
}


// 2. MANEJAR EL FORMULARIO DE INSTALACIÓN
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_install'])) {
    // --- Recopilar datos del formulario ---
    $db_host = $_POST['db_host'];
    $db_name = $_POST['db_name'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $admin_email = trim($_POST['admin_email']);
    $admin_password = $_POST['admin_password'];

    // --- Validaciones básicas ---
    if (empty($db_host) || empty($db_name) || empty($db_user) || empty($admin_email) || empty($admin_password)) {
        $error_message = "Todos los campos son obligatorios.";
    } elseif (strlen($admin_password) < 8) {
        $error_message = "La contraseña del administrador debe tener al menos 8 caracteres.";
    } elseif (!filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
        $error_message = "El formato del email del administrador no es válido.";
    } else {
        // --- Iniciar proceso de instalación ---

        // a) Probar conexión a la base de datos
        $conn = @new mysqli($db_host, $db_user, $db_pass, $db_name);
        if ($conn->connect_error) {
            $error_message = "Error de Conexión a la Base de Datos: " . $conn->connect_error . ". Revisa el Host, Nombre de la Base de Datos, Usuario y Contraseña. Asegúrate de que la base de datos ya ha sido creada en tu hosting.";
        } else {
            // La conexión fue exitosa, la base de datos existe.

            // b) Crear archivo de configuración
            $config_content = "<?php\n"
                . "define('DB_HOST', '" . addslashes($db_host) . "');\n"
                . "define('DB_NAME', '" . addslashes($db_name) . "');\n"
                . "define('DB_USER', '" . addslashes($db_user) . "');\n"
                . "define('DB_PASS', '" . addslashes($db_pass) . "');\n"
                . "define('DB_CHARSET', 'utf8mb4');\n"
                . "?>";

            if (file_put_contents($config_file, $config_content) === false) {
                $error_message = "¡Error Crítico! No se pudo escribir en el archivo <code>$config_file</code>. Verifica los permisos de escritura.";
            } else {
                // c) Definir y ejecutar SQL para crear tablas
                $sql_statements = "
                CREATE TABLE IF NOT EXISTS `usuarios` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `nombre` varchar(100) NOT NULL,
                  `apellido` varchar(100) NOT NULL,
                  `email` varchar(100) NOT NULL,
                  `password` varchar(255) NOT NULL,
                  `role` enum('admin','profesional','asistente') NOT NULL,
                  `status` enum('activo','inactivo') NOT NULL DEFAULT 'activo',
                  `telefono` varchar(20) DEFAULT NULL,
                  `especialidad` varchar(100) DEFAULT NULL,
                  PRIMARY KEY (`id`),
                  UNIQUE KEY `email` (`email`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `pacientes` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `nombre` varchar(100) NOT NULL,
                  `apellido` varchar(100) NOT NULL,
                  `fecha_nacimiento` date NOT NULL,
                  `genero` enum('Masculino','Femenino','Otro') NOT NULL,
                  `telefono` varchar(20) NOT NULL,
                  `email` varchar(100) DEFAULT NULL,
                  `direccion` text DEFAULT NULL,
                  `historial_medico` text DEFAULT NULL,
                  `fecha_registro` timestamp NOT NULL DEFAULT current_timestamp(),
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `servicios` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `nombre_servicio` varchar(255) NOT NULL,
                  `descripcion` text DEFAULT NULL,
                  `costo` decimal(10,2) NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `citas` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `id_paciente` int(11) NOT NULL,
                  `id_profesional` int(11) NOT NULL,
                  `id_servicio` int(11) DEFAULT NULL,
                  `fecha_cita` date NOT NULL,
                  `hora_cita` time NOT NULL,
                  `estado` enum('programada','confirmada','cancelada','completada') NOT NULL DEFAULT 'programada',
                  `notas` text DEFAULT NULL,
                  PRIMARY KEY (`id`),
                  KEY `id_paciente` (`id_paciente`),
                  KEY `id_profesional` (`id_profesional`),
                  KEY `id_servicio` (`id_servicio`),
                  CONSTRAINT `citas_ibfk_1` FOREIGN KEY (`id_paciente`) REFERENCES `pacientes` (`id`) ON DELETE CASCADE,
                  CONSTRAINT `citas_ibfk_2` FOREIGN KEY (`id_profesional`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
                  CONSTRAINT `citas_ibfk_3` FOREIGN KEY (`id_servicio`) REFERENCES `servicios` (`id`) ON DELETE SET NULL
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `horarios_profesionales` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `id_profesional` int(11) NOT NULL,
                  `dia_semana` enum('Lunes','Martes','Miércoles','Jueves','Viernes','Sábado','Domingo') NOT NULL,
                  `hora_inicio` time NOT NULL,
                  `hora_fin` time NOT NULL,
                  PRIMARY KEY (`id`),
                  KEY `id_profesional` (`id_profesional`),
                  CONSTRAINT `horarios_profesionales_ibfk_1` FOREIGN KEY (`id_profesional`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `pagos` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `id_cita` int(11) NOT NULL,
                  `monto` decimal(10,2) NOT NULL,
                  `fecha_pago` timestamp NOT NULL DEFAULT current_timestamp(),
                  `metodo_pago` enum('Efectivo','Tarjeta','Transferencia') NOT NULL,
                  PRIMARY KEY (`id`),
                  KEY `id_cita` (`id_cita`),
                  CONSTRAINT `pagos_ibfk_1` FOREIGN KEY (`id_cita`) REFERENCES `citas` (`id`) ON DELETE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `configuracion` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `nombre_clinica` varchar(255) NOT NULL,
                  `direccion_clinica` text NOT NULL,
                  `telefono_clinica` varchar(20) NOT NULL,
                  `email_clinica` varchar(100) NOT NULL,
                  `logo_url` varchar(255) DEFAULT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                INSERT INTO `configuracion` (`nombre_clinica`, `direccion_clinica`, `telefono_clinica`, `email_clinica`) VALUES
                ('Mi Clínica', 'Dirección de tu clínica', '123456789', 'contacto@miclinica.com');
                ";

                if ($conn->multi_query($sql_statements)) {
                    // Limpiar resultados de multi_query
                    while ($conn->next_result()) { if ($res = $conn->store_result()) { $res->free(); } }

                    // d) Crear el usuario administrador
                    $hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);
                    $stmt = $conn->prepare("INSERT INTO usuarios (nombre, apellido, email, password, role, status) VALUES (?, ?, ?, ?, ?, ?)");
                    $nombre = 'Admin'; $apellido = 'Principal'; $role = 'admin'; $status = 'activo';
                    $stmt->bind_param("ssssss", $nombre, $apellido, $admin_email, $hashed_password, $role, $status);

                    if ($stmt->execute()) {
                        $install_completed = true; // ¡Instalación exitosa!
                    } else {
                        $error_message = "Error al crear el administrador: " . $stmt->error;
                    }
                    $stmt->close();
                } else {
                    $error_message = "Error al ejecutar la creación de las tablas: " . $conn->error;
                }
            }
            $conn->close();
        }
    }
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalación - ClinicApps</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; line-height: 1.6; color: #333; max-width: 800px; margin: 40px auto; padding: 0 15px; background-color: #f4f7f6; }
        h1 { color: #2c3e50; text-align: center; }
        .container { background: #fff; border: 1px solid #ddd; border-radius: 8px; padding: 30px; box-shadow: 0 4px 10px rgba(0,0,0,0.08); }
        .message { padding: 15px; border-radius: 5px; margin-bottom: 20px; border: 1px solid; }
        .message.error { color: #c0392b; background-color: #f9e4e4; border-color: #e74c3c; }
        .message.success { color: #27ae60; background-color: #eafaf1; border-color: #2ecc71; }
        .message.warning { color: #d35400; background-color: #fef5e7; border-color: #f39c12; }
        form { margin-top: 20px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
        .button { display: inline-block; width: 100%; background-color: #3498db; color: #fff; padding: 12px 20px; border-radius: 4px; text-decoration: none; cursor: pointer; border: none; font-size: 16px; font-weight: bold; }
        .button:hover { background-color: #2980b9; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Instalador de ClinicApps</h1>

        <?php if ($error_message): ?>
            <div class="message error"><?= $error_message ?></div>
        <?php endif; ?>

        <?php if ($install_completed): ?>
            
            <h2>¡Instalación Completada!</h2>
            <div class="message success"><strong>¡Éxito!</strong> El sistema ha sido instalado y el usuario administrador ha sido creado.</div>
            <div class="message warning text-center">
                <strong>¡MUY IMPORTANTE!</strong><br>
                Por razones de seguridad, elimina ahora el archivo <code>install.php</code> de tu servidor.
            </div>
            <div class="text-center" style="margin-top: 20px;">
                <a href="index.php" class="button" style="display: inline-block; width: auto;">Ir a la Página de Inicio</a>
            </div>

        <?php else: ?>

            <form action="install.php" method="POST">
                <h2>1. Datos de la Base de Datos</h2>
                <div class="form-group">
                    <label for="db_host">Host</label>
                    <input type="text" id="db_host" name="db_host" value="<?= htmlspecialchars($_POST['db_host'] ?? 'localhost') ?>" required>
                </div>
                <div class="form-group">
                    <label for="db_name">Nombre de la Base de Datos</label>
                    <input type="text" id="db_name" name="db_name" value="<?= htmlspecialchars($_POST['db_name'] ?? '') ?>" required>
                </div>
                <div class="form-group">
                    <label for="db_user">Usuario</label>
                    <input type="text" id="db_user" name="db_user" value="<?= htmlspecialchars($_POST['db_user'] ?? '') ?>" required>
                </div>
                <div class="form-group">
                    <label for="db_pass">Contraseña</label>
                    <input type="password" id="db_pass" name="db_pass">
                </div>

                <hr style="margin: 25px 0;">

                <h2>2. Cuenta de Administrador</h2>
                <div class="form-group">
                    <label for="admin_email">Email del Administrador</label>
                    <input type="email" id="admin_email" name="admin_email" value="<?= htmlspecialchars($_POST['admin_email'] ?? '') ?>" required>
                </div>
                <div class="form-group">
                    <label for="admin_password">Contraseña (mín. 8 caracteres)</label>
                    <input type="password" id="admin_password" name="admin_password" required minlength="8">
                </div>
                
                <button type="submit" name="submit_install" class="button">Instalar Ahora</button>
            </form>

        <?php endif; ?>
    </div>
</body>
</html>