<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>

    <div class="container">
        <h1>Dashboard</h1>

        <!-- Tarjetas de Resumen -->
        <div class="summary-cards">
            <div class="summary-card">
                <h4>Pacientes Activos</h4>
                <p id="metric-pacientes-activos">0</p>
            </div>
            <div class="summary-card">
                <h4>Citas para Hoy</h4>
                <p id="metric-citas-hoy">0</p>
            </div>
            <div class="summary-card">
                <h4>Ingresos del Mes</h4>
                <p id="metric-ingresos-mes">0</p>
            </div>
        </div>

        <!-- Panel de Citas por Confirmar -->
        <div class="dashboard-column full-width">
            <h2>Citas por Confirmar</h2>
            <div id="citas-por-confirmar-list" class="dashboard-list horizontal-list">
                <!-- Las citas que necesitan confirmación se cargarán aquí -->
                <p>Cargando...</p>
            </div>
        </div>

        <div class="dashboard-grid">
            <!-- Columna de Próximas Citas -->
            <div class="dashboard-column">
                <h2>Próximas Citas de Hoy</h2>
                <div id="proximas-citas-list" class="dashboard-list">
                    <!-- Las citas se cargarán aquí -->
                    <p>Cargando...</p>
                </div>
            </div>

            <!-- Columna de Actividad Reciente -->
            <div class="dashboard-column">
                <h2>Actividad Reciente</h2>
                <div id="actividad-reciente-list" class="dashboard-list">
                    <!-- La actividad se cargará aquí -->
                    <p>Cargando...</p>
                </div>
            </div>

            <!-- Columna de Accesos Rápidos -->
            <div class="dashboard-column">
                <h2>Accesos Rápidos</h2>
                <div class="quick-access">
                    <a href="citas.php" class="quick-access-btn">
                        <span>📅</span> Agendar Cita
                    </a>
                    <a href="pacientes.php" class="quick-access-btn">
                        <span>👤</span> Nuevo Paciente
                    </a>
                    <a href="financiero.php" class="quick-access-btn">
                        <span>💰</span> Registrar Ingreso
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="dashboard.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>