<?php include '_header.php'; ?>

<main class="container">
    <div class="page-header">
        <h1>Configuración del Sistema</h1>
        <p>Ajusta los parámetros generales, la información de la clínica y las opciones de facturación.</p>
    </div>

    <div class="tabs-container">
        <div class="tab-nav">
            <button class="tab-link active" data-tab="tab-general">General</button>
            <button class="tab-link" data-tab="tab-legal">Información Legal y Facturación</button>
            <button class="tab-link" data-tab="tab-formato">Formato de Moneda</button>
            <button class="tab-link" data-tab="tab-citas">Citas</button>
            <button class="tab-link" data-tab="tab-activity">Registro de Actividad</button>
        </div>

        <form id="config-form">
            <div id="tab-general" class="tab-content active">
                <h3>Información de la Clínica</h3>
                <div class="form-grid">
                    <div class="form-group">
                        <label for="clinica_nombre">Nombre de la Clínica</label>
                        <input type="text" id="clinica_nombre" name="clinica_nombre">
                    </div>
                    <div class="form-group form-group-full">
                        <label for="clinica_logo">URL del Logo</label>
                        <div class="input-with-preview">
                            <input type="text" id="clinica_logo" name="clinica_logo">
                            <button type="button" id="clear-logo-btn" class="clear-btn" title="Limpiar">&times;</button>
                            <img id="logo-preview" src="placeholder.png" alt="Vista previa del logo">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="clinica_direccion">Dirección</label>
                        <input type="text" id="clinica_direccion" name="clinica_direccion">
                    </div>
                    <div class="form-group">
                        <label for="clinica_telefono">Teléfono</label>
                        <input type="tel" id="clinica_telefono" name="clinica_telefono">
                    </div>
                    <div class="form-group">
                        <label for="clinica_email">Email de Contacto</label>
                        <input type="email" id="clinica_email" name="clinica_email">
                    </div>
                </div>
            </div>

            <div id="tab-legal" class="tab-content">
                <h3>Información Legal y Facturación</h3>
                <div class="form-grid">
                    <div class="form-group">
                        <label for="legal_nombre">Nombre Legal / Razón Social</label>
                        <input type="text" id="legal_nombre" name="legal_nombre">
                    </div>
                    <div class="form-group">
                        <label for="legal_documento">Documento Legal</label>
                        <input type="text" id="legal_documento" name="legal_documento">
                    </div>
                    <div class="form-group">
                        <label for="facturacion_ruc">RUC</label>
                        <input type="text" id="facturacion_ruc" name="facturacion_ruc">
                    </div>
                </div>
            </div>

            <div id="tab-formato" class="tab-content">
                <h3>Formato de Moneda y Números</h3>
                <div class="form-grid">
                    <div class="form-group">
                        <label for="simbolo_moneda">Símbolo de Moneda (ej. Gs., $)</label>
                        <input type="text" id="simbolo_moneda" name="simbolo_moneda">
                    </div>
                    <div class="form-group">
                        <label for="separador_miles">Separador de Miles (ej. . o ,)</label>
                        <input type="text" id="separador_miles" name="separador_miles">
                    </div>
                    <div class="form-group">
                        <label for="separador_decimales">Separador de Decimales (ej. , o .)</label>
                        <input type="text" id="separador_decimales" name="separador_decimales">
                    </div>
                    <div class="form-group">
                        <label for="cantidad_decimales">Cantidad de Decimales</label>
                        <input type="number" id="cantidad_decimales" name="cantidad_decimales" min="0" max="4">
                    </div>
                </div>
            </div>

            <div id="tab-citas" class="tab-content">
                <h3>Gestión de Citas</h3>
                <div class="form-grid">
                    <div class="form-group">
                        <label for="horas_confirmar_cita">Horas de antelación para confirmar cita</label>
                        <input type="number" id="horas_confirmar_cita" name="horas_confirmar_cita" min="1">
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="button primary">Guardar Cambios</button>
            </div>
        </form> <!-- El formulario termina aquí -->

        <!-- El contenido de la pestaña de actividad va FUERA del formulario -->
        <div id="tab-activity" class="tab-content">
            <h3>Registro de Actividad del Sistema</h3>

            <div class="filters-container">
                <div class="form-group">
                    <label for="filter-start-date">Desde</label>
                    <input type="date" id="filter-start-date">
                </div>
                <div class="form-group">
                    <label for="filter-end-date">Hasta</label>
                    <input type="date" id="filter-end-date">
                </div>
                <div class="form-group">
                    <label for="filter-user">Usuario</label>
                    <select id="filter-user">
                        <option value="">Todos</option>
                    </select>
                </div>
                <button id="apply-filters-btn" class="button primary">Filtrar</button>
                <button id="clear-filters-btn" class="button">Limpiar</button>
            </div>

            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th style="width: 25%;">Fecha y Hora</th>
                            <th style="width: 20%;">Usuario</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody id="activity-log-body">
                        <!-- Los datos se cargarán aquí dinámicamente -->
                    </tbody>
                </table>
            </div> 
        </div>
    </div>
</main>

<script src="configuracion.js"></script>

<?php include '_footer.php'; ?>