<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>
    <div class="container">
        <div class="controls">
            <input type="text" id="search-input" placeholder="Buscar por paciente o profesional...">
            <div class="view-controls">
                <button class="view-btn" data-view="day">Día</button>
                <button class="view-btn active" data-view="week">Semana</button>
                <button class="view-btn" data-view="month">Mes</button>
                <button class="view-btn" data-view="list">Lista</button>
                <button id="open-modal-btn">Nueva Cita</button>
            </div>
        </div>

        <div class="calendar-header">
            <button id="prev-btn">&larr;</button>
            <h2 id="calendar-title">Agenda de Citas</h2>
            <button id="next-btn">&rarr;</button>
        </div>

        <div id="list-view" style="display: none;">
            <table id="citas-table">
            <thead>
                <tr>
                    <th data-sort="fecha">Fecha y Hora</th>
                    <th data-sort="paciente">Paciente</th>
                    <th data-sort="profesional">Profesional</th>
                    <th data-sort="estado">Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="citas-table-body">
                <!-- Filas insertadas por JavaScript -->
            </tbody>
            </table>
        </div>

        <div id="calendar-view">
            <!-- La vista de calendario se generará aquí por JavaScript -->
        </div>

        <!-- The Modal -->
        <div id="cita-modal" class="modal">
            <div class="modal-content">
                <span class="close-btn">&times;</span>
                <h2>Detalles de la Cita</h2>
                <form id="cita-form">
                    <input type="hidden" id="cita-id" name="id">
                    
                    <div class="form-grid">
                        <select id="paciente_id" name="paciente_id" required>
                            <option value="">-- Seleccionar Paciente --</option>
                            <!-- Opciones cargadas por JS -->
                        </select>
                        <select id="profesional_id" name="profesional_id" required>
                            <option value="">-- Seleccionar Profesional --</option>
                            <!-- Opciones cargadas por JS -->
                        </select>
                        <input type="date" id="fecha" name="fecha" required>
                        <input type="time" id="hora" name="hora" required>
                    </div>

                    <label for="estado">Estado de la Cita:</label>
                    <select id="estado" name="estado" required>
                        <option value="Programada">Programada</option>
                        <option value="Confirmada">Confirmada</option>
                        <option value="Realizada">Realizada</option>
                        <option value="Cancelada">Cancelada</option>
                    </select>

                    <textarea id="notas" name="notas" placeholder="Notas o recordatorios para la cita..." rows="4"></textarea>
                    
                    <button type="submit">Guardar Cita</button>

                    <div id="cita-history-container" class="audit-log-container" style="display: none;">
                        <h4>Historial de Cambios</h4>
                        <ul id="cita-history-list">
                        </ul>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="citas.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>