<?php
session_start();
if (isset($_SESSION['username'])) {
    header('Location: index.html');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Bridgi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex flex-column min-vh-100 bg-light">
    <div class="container my-auto d-flex justify-content-center align-items-center">
        <div class="card shadow-sm" style="max-width: 50rem; overflow: hidden;">
            <div class="row g-0">
                <div class="col-md-6 d-none d-md-flex align-items-center justify-content-center bg-white">
                    <img src="Images/bridgi.png" class="img-fluid p-3" alt="Logo Bridgi">
                </div>
                <div class="col-md-6">
                    <div class="card-body p-4">
                        <h3 class="card-title text-center mb-4">Bridgi</h3>
                        <div id="alert-placeholder"></div>
                        <form id="login-form">
                            <div class="mb-3">
                                <label for="username" class="form-label">Usuario</label>
                                <input type="text" class="form-control" id="username" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Contraseña</label>
                                <input type="password" class="form-control" id="password" required>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="remember">
                                <label class="form-check-label" for="remember">Recordar sesión</label>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Iniciar Sesión</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center text-muted py-3">
        Bridgi "El Puente Contable". Dunamis Group 2025.
    </footer>

    <script>
        document.getElementById('login-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            const remember = document.getElementById('remember').checked;
            const alertPlaceholder = document.getElementById('alert-placeholder');

            const response = await fetch('../api.php?action=login', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ username, password, remember })
            });

            const result = await response.json();
            if (response.ok && result.success) {
                window.location.href = 'index.html';
            } else {
                alertPlaceholder.innerHTML = `<div class="alert alert-danger" role="alert">${result.error || 'Error desconocido.'}</div>`;
            }
        });
    </script>
</body>
</html>