<?php
header('Content-Type: application/json');

$jsonDbFile = 'descargas.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    // Validar que los datos necesarios no estén vacíos.
    if (empty($data['name']) || empty($data['email']) || empty($data['fileName'])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Nombre y correo son obligatorios.']);
        exit;
    }

    $downloads = file_exists($jsonDbFile) ? json_decode(file_get_contents($jsonDbFile), true) : [];

    $newDownload = [
        'id' => uniqid('dl_'),
        'name' => htmlspecialchars($data['name']),
        'email' => htmlspecialchars($data['email']),
        'fileName' => htmlspecialchars($data['fileName']),
        'articleId' => htmlspecialchars($data['articleId']),
        'timestamp' => date('Y-m-d H:i:s')
    ];

    array_unshift($downloads, $newDownload);

    file_put_contents($jsonDbFile, json_encode($downloads, JSON_PRETTY_PRINT));

    echo json_encode(['status' => 'success', 'message' => 'Datos registrados.']);
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido.']);
}
?>