<?php
// get_single_post.php



header('Content-Type: application/json');

$postId = $_GET['id'] ?? null;

if (!$postId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'ID de artículo no proporcionado.']);
    exit;
}

$db_file = 'db.json';
$response = ['success' => false, 'post' => null];

if (file_exists($db_file)) {
    $json_data = file_get_contents($db_file);
    // Forzar la decodificación como UTF-8 para evitar problemas con caracteres especiales.
    $json_data = mb_convert_encoding($json_data, 'UTF-8', 'auto');
    $db = json_decode($json_data, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['success' => false, 'message' => 'Error al decodificar el archivo JSON: ' . json_last_error_msg()]);
        exit;
    }
    $blogPosts = $db['blogPosts'] ?? [];

    foreach ($blogPosts as $post) {
        if ($post['id'] === $postId) {
            $response['success'] = true;
            $response['post'] = $post;
            break;
        }
    }
}

echo json_encode($response);