<?php
// contact_handler.php

// Establecer la cabecera para devolver JSON
header('Content-Type: application/json');

// Solo permitir peticiones POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit;
}

// Obtener los datos enviados en el cuerpo de la petición
$input = json_decode(file_get_contents('php://input'), true);

$name = trim($input['name'] ?? '');
$email = trim($input['email'] ?? '');
$country_code = trim($input['country_code'] ?? '');
$phone = trim($input['phone'] ?? '');
$subject = trim($input['subject'] ?? '');
$message = trim($input['message'] ?? '');
$honeypot = $input['honeypot'] ?? '';

// Trampa simple para bots (honeypot)
if (!empty($honeypot)) {
    // Respondemos con éxito para engañar al bot, pero no guardamos nada.
    echo json_encode(['success' => true, 'message' => 'Tu mensaje fue enviado con éxito. En breve un consultor se comunicará con usted.']);
    exit;
}

if (empty($name) || empty($email) || empty($phone) || empty($subject) || empty($message)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Por favor, complete todos los campos requeridos.']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'La dirección de correo electrónico no es válida.']);
    exit;
}

$db_file = 'db.json';
if (!file_exists($db_file)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error interno del servidor.']);
    exit;
}

$db = json_decode(file_get_contents($db_file), true);

$newContact = [
    'id' => uniqid('contact_'),
    'date' => date('Y-m-d H:i:s'),
    'name' => $name, 
    'email' => $email, 
    'phone' => $country_code . ' ' . $phone,
    'subject' => $subject, 
    'message' => $message
];
array_unshift($db['contacts'], $newContact); // Añadir al principio para ver los más nuevos primero

file_put_contents($db_file, json_encode($db, JSON_PRETTY_PRINT));

echo json_encode(['success' => true, 'message' => 'Tu mensaje fue enviado con éxito. En breve un consultor se comunicará con usted.']);