document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('login-form');
    const errorMessage = document.getElementById('error-message');

    loginForm.addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(loginForm);
        errorMessage.textContent = ''; // Limpiar errores previos

        fetch('api/login.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.href = 'index.php'; // Redirigir al dashboard
            } else {
                errorMessage.textContent = data.message || 'Error desconocido.';
            }
        })
        .catch(error => {
            console.error('Error en la solicitud de login:', error);
            errorMessage.textContent = 'No se pudo conectar con el servidor.';
        });
    });
});
