<?php
    include 'api/check_session.php';
    $puesto = $_SESSION['user_puesto'] ?? '';

    // Roles que NO pueden ver Finanzas
    $no_finance_roles = ['CM', 'Copy', 'Diseñadores', 'Audiovisual', 'Periodismo', 'BTL', 'ATL'];
    // Roles que NO pueden ver Profesionales
    $no_professionals_roles = ['Copy', 'Diseñadores', 'Audiovisual', 'Periodismo', 'BTL', 'ATL'];

    $can_see_finance = !in_array($puesto, $no_finance_roles);
    $can_see_professionals = !in_array($puesto, $no_professionals_roles);
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Platflow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="global-chat.css">
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse h-100">
            <div class="position-sticky pt-3">
                <h4 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <a href="/platflow/" class="text-decoration-none text-muted"><span>Platflow</span></a>
                </h4>
                <ul class="nav flex-column mb-auto">
                    <li class="nav-item"><a class="nav-link active" aria-current="page" href="/platflow/"><i class="bi bi-house-door-fill me-2"></i>Dashboard</a></li>
                    <?php if ($can_see_professionals): ?>
                    <li class="nav-item"><a class="nav-link" href="professionals.html"><i class="bi bi-people-fill me-2"></i>Profesionales</a></li>
                    <?php endif; ?>
                    <li class="nav-item"><a class="nav-link" href="clients.html"><i class="bi bi-person-rolodex me-2"></i>Clientes</a></li>
                    <li class="nav-item"><a class="nav-link" href="projects.html"><i class="bi bi-kanban-fill me-2"></i>Proyectos</a></li>
                    <li class="nav-item"><a class="nav-link" href="content-grid.html"><i class="bi bi-grid-3x3-gap-fill me-2"></i>Editorial de Redes</a></li>
                    <li class="nav-item"><a class="nav-link" href="media-plan.html"><i class="bi bi-calendar-check-fill me-2"></i>Plan de Medios</a></li>
                    <li class="nav-item"><a class="nav-link" href="analizar-datos.html"><i class="bi bi-bar-chart-line-fill me-2"></i>Analizar Datos</a></li>
                    <?php if ($can_see_finance): ?>
                    <li class="nav-item"><a class="nav-link" href="finance.html"><i class="bi bi-currency-dollar me-2"></i>Finanzas</a></li>
                    <?php endif; ?>
                    <li class="nav-item"><a class="nav-link" href="all-tasks.html"><i class="bi bi-check2-circle me-2"></i>Todas las Tareas</a></li>
                    <li class="nav-item">
                        <a class="nav-link collapsed" href="#agendasSubmenu" data-bs-toggle="collapse" aria-expanded="false">
                            <i class="bi bi-calendar3 me-2"></i>Agendas
                        </a>
                        <ul class="collapse list-unstyled" id="agendasSubmenu">
                            <li><a class="nav-link" href="agenda-tareas.html">› Tareas</a></li>
                            <li><a class="nav-link" href="agenda-editorial.html">› Editorial</a></li>
                            <li><a class="nav-link" href="agenda-proyectos.html">› Proyectos</a></li>
                            <li><a class="nav-link" href="agenda-plan-medios.html">› Plan de Medios</a></li>
                        </ul>
                    </li>
                </ul>
                <hr>
                <div class="px-3 mt-auto pb-3">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" role="switch" id="dark-mode-toggle">
                        <label class="form-check-label" for="dark-mode-toggle">Modo Oscuro</label>
                    </div>
                    <ul class="nav flex-column">
                        <li class="nav-item"><a class="nav-link" href="configuracion.html"><i class="bi bi-gear-fill me-2"></i>Configuración</a></li>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="d-flex align-items-center ms-auto">
                    <div id="global-search-container" class="me-2" style="position: relative;">
                        <input class="form-control form-control-sm" type="search" id="global-search-input" placeholder="Buscar proyecto, cliente, tarea..." aria-label="Search" style="width: 300px;">
                        <ul id="global-search-results" class="dropdown-menu">
                            <!-- Search results will be populated here -->
                        </ul>
                    </div>
                    <button id="global-chat-button" class="btn btn-outline-primary" type="button" title="Abrir Chat">
                        <i class="bi bi-chat-dots-fill position-relative">
                            <span id="chat-notification-badge" class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle" style="display: none;"></span>
                        </i>
                    </button>
                </div>
            </div>

            <!-- Stat Cards -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card text-white bg-primary">
                        <div class="card-body">
                            <h5 class="card-title"><i class="bi bi-briefcase-fill"></i> Proyectos Activos</h5>
                            <p class="card-text fs-2" id="active-projects-count">0</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-white bg-warning">
                        <div class="card-body">
                            <h5 class="card-title"><i class="bi bi-list-task"></i> Tareas Pendientes</h5>
                            <p class="card-text fs-2" id="pending-tasks-count">0</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-white bg-danger">
                        <div class="card-body">
                            <h5 class="card-title"><i class="bi bi-exclamation-triangle-fill"></i> Tareas Vencidas</h5>
                            <p class="card-text fs-2" id="overdue-tasks-count">0</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Dashboard Content -->
            <div class="row">
                <!-- Left Column: Lists -->
                <div class="col-lg-4">
                    <!-- Recent Projects -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="bi bi-clock-history"></i> Proyectos Recientes
                        </div>
                        <ul class="list-group list-group-flush" id="recent-projects-list">
                            <!-- Items will be inserted here -->
                        </ul>
                    </div>

                    <!-- Upcoming Tasks -->
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-calendar-week"></i> Tareas Próximas a Vencer
                        </div>
                        <ul class="list-group list-group-flush" id="upcoming-tasks-list">
                            <!-- Items will be inserted here -->
                        </ul>
                    </div>
                </div>

                <!-- Right Column: Calendar -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-body">
                            <div id="calendar"></div>
                        </div>
                    </div>
                </div>
            </div>

        </main>
    </div>
</div>

<!-- Modal para el Chat Global -->
<div class="modal fade" id="globalChatModal" tabindex="-1" aria-labelledby="globalChatModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content" style="height: 85vh;">
            <div class="modal-header">
                <h5 class="modal-title" id="globalChatModalLabel"><i class="bi bi-chat-dots-fill"></i> Chat Interno</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="row g-0 h-100">
                    <!-- Columna Izquierda: Lista de Conversaciones -->
                    <div id="conversations-list" class="col-lg-4 col-md-5 border-end">
                        <div class="p-3 border-bottom">
                            <button id="new-chat-button" class="btn btn-primary w-100">
                                <i class="bi bi-plus-circle"></i> Nueva Conversación
                            </button>
                        </div>
                        <div id="conv-list-items" class="list-group list-group-flush overflow-auto">
                            <!-- Las conversaciones se cargarán aquí -->
                        </div>
                    </div>
                    <!-- Columna Derecha: Panel de Chat Activo -->
                    <div id="chat-panel" class="col-lg-8 col-md-7 d-flex flex-column">
                        <div id="chat-header" class="p-3 border-bottom d-flex align-items-center" style="display: none !important;">
                            <!-- La cabecera del chat se cargará aquí -->
                        </div>
                        <div id="chat-messages" class="flex-grow-1 p-4 overflow-auto">
                            <div class="text-center p-5 text-muted">Selecciona una conversación para empezar.</div>
                        </div>
                        <div id="chat-input" class="p-3 border-top" style="display: none;">
                            <!-- El input de mensaje se cargará aquí -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Nueva Conversación (Requerido por global-chat.js) -->
<div class="modal fade" id="new-chat-modal" tabindex="-1" aria-labelledby="newChatModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="newChatModalLabel">Nueva Conversación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs" id="modal-tabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active tab-link" data-tab="individual" type="button">Individual</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link tab-link" data-tab="group" type="button">Grupo</button>
                    </li>
                </ul>
                <div id="individual" class="tab-content active">
                    <input type="text" id="search-professional" class="form-control mb-3" placeholder="Buscar profesional...">
                    <ul id="professionals-list" class="list-group"></ul>
                </div>
                <div id="group" class="tab-content">
                    <div class="mb-3">
                        <label for="group-name" class="form-label">Nombre del grupo</label>
                        <input type="text" id="group-name" class="form-control" placeholder="Escribe un nombre para el grupo...">
                    </div>
                    <div class="mb-3">
                        <label for="group-photo" class="form-label">Foto del grupo (opcional)</label>
                        <input type="file" id="group-photo" class="form-control" accept="image/*">
                        <img id="group-photo-preview" src="#" alt="Vista previa" class="img-thumbnail mt-2" style="display: none; max-width: 100px; max-height: 100px;">
                    </div>
                    <hr>
                    <h6>Añadir miembros</h6>
                    <div id="selected-members-container" class="mb-2"></div>
                    <input type="text" id="search-group-members" class="form-control mb-2" placeholder="Buscar profesional para añadir...">
                    <ul id="group-members-list" class="list-group" style="max-height: 150px; overflow-y: auto;"></ul>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="create-group-button" style="display: none;">Crear Grupo</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- FullCalendar JS -->
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js'></script>
<script src="js/main.js"></script>
<script src="js/global-search.js"></script>
<script src="js/dashboard.js"></script>
<script src="global-chat.js"></script>


</body>
</html>